/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.SqmInsertTranslation;
import org.hibernate.query.sqm.sql.SqmInsertTranslator;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;

public class StandardSqmInsertTranslator
extends BaseSqmToSqlAstConverter
implements SqmInsertTranslator,
DomainResultCreationState {
    private final List<DomainResult> domainResults = CollectionHelper.arrayList(10);

    public StandardSqmInsertTranslator(SqlAstCreationContext creationContext, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings) {
        super(creationContext, queryOptions, domainParameterXref, domainParameterBindings);
    }

    @Override
    public SqmInsertTranslation translate(SqmInsertStatement sqmStatement) {
        InsertStatement sqlAst = sqmStatement instanceof SqmInsertSelectStatement ? this.visitInsertSelectStatement((SqmInsertSelectStatement)sqmStatement) : this.visitInsertValuesStatement((SqmInsertValuesStatement)sqmStatement);
        return new SqmInsertTranslation(sqlAst, this.getJdbcParamsBySqmParam());
    }

    @Override
    public CteStatement translate(SqmCteStatement sqmCte) {
        return this.visitCteStatement(sqmCte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InsertStatement visitInsertSelectStatement(SqmInsertSelectStatement sqmStatement) {
        InsertStatement insertStatement = new InsertStatement();
        String entityName = ((SqmRoot)sqmStatement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.getProcessingStateStack().push(new SqlAstProcessingStateImpl(null, this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)sqmStatement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(rootPath, ((AbstractSqmFrom)((Object)sqmStatement.getTarget())).getExplicitAlias(), false, LockMode.WRITE, stem -> this.getSqlAliasBaseGenerator().createSqlAliasBase(stem), this.getSqlExpressionResolver(), () -> predicate -> {
                this.additionalRestrictions = predicate;
            }, this.getCreationContext());
            if (!rootTableGroup.getTableReferenceJoins().isEmpty() || !rootTableGroup.getTableGroupJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM INSERT-SELECT");
            }
            this.getFromClauseIndex().registerTableGroup(rootPath, rootTableGroup);
            insertStatement.setTargetTable(rootTableGroup.getPrimaryTableReference());
            List<SqmPath> targetPaths = sqmStatement.getInsertionTargetPaths();
            for (SqmPath target : targetPaths) {
                Assignable assignable = (Assignable)target.accept(this);
                insertStatement.addTargetColumnReferences(assignable.getColumnReferences());
            }
            insertStatement.setSourceSelectStatement(this.visitQuerySpec(sqmStatement.getSelectQuerySpec()));
            InsertStatement insertStatement2 = insertStatement;
            return insertStatement2;
        }
        finally {
            this.getProcessingStateStack().pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InsertStatement visitInsertValuesStatement(SqmInsertValuesStatement sqmStatement) {
        InsertStatement insertValuesStatement = new InsertStatement();
        String entityName = ((SqmRoot)sqmStatement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.getProcessingStateStack().push(new SqlAstProcessingStateImpl(null, this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)sqmStatement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(rootPath, ((AbstractSqmFrom)((Object)sqmStatement.getTarget())).getExplicitAlias(), false, LockMode.WRITE, stem -> this.getSqlAliasBaseGenerator().createSqlAliasBase(stem), this.getSqlExpressionResolver(), () -> predicate -> {
                this.additionalRestrictions = predicate;
            }, this.getCreationContext());
            if (!rootTableGroup.getTableReferenceJoins().isEmpty() || !rootTableGroup.getTableGroupJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM INSERT-SELECT");
            }
            this.getFromClauseIndex().registerTableGroup(rootPath, rootTableGroup);
            insertValuesStatement.setTargetTable(rootTableGroup.getPrimaryTableReference());
            List<SqmPath> targetPaths = sqmStatement.getInsertionTargetPaths();
            for (SqmPath target : targetPaths) {
                Assignable assignable = (Assignable)target.accept(this);
                insertValuesStatement.addTargetColumnReferences(assignable.getColumnReferences());
            }
            List<SqmValues> valuesList = sqmStatement.getValuesList();
            for (SqmValues sqmValues : valuesList) {
                insertValuesStatement.getValuesList().add(this.visitValues(sqmValues));
            }
            InsertStatement insertStatement = insertValuesStatement;
            return insertStatement;
        }
        finally {
            this.getProcessingStateStack().pop();
        }
    }

    private DomainResultProducer resolveDomainResultProducer(SqmSelection sqmSelection) {
        return (DomainResultProducer)sqmSelection.getSelectableNode().accept(this);
    }

    @Override
    public Void visitSelection(SqmSelection sqmSelection) {
        DomainResultProducer resultProducer = this.resolveDomainResultProducer(sqmSelection);
        DomainResult domainResult = resultProducer.createDomainResult(sqmSelection.getAlias(), this);
        this.domainResults.add(domainResult);
        return null;
    }

    @Override
    public Values visitValues(SqmValues sqmValues) {
        Values values = new Values();
        for (SqmExpression expression : sqmValues.getExpressions()) {
            values.getExpressions().add((Expression)expression.accept(this));
        }
        return values;
    }

    @Override
    public SelectStatement visitSelectStatement(SqmSelectStatement statement) {
        QuerySpec querySpec = this.visitQuerySpec((SqmQuerySpec)statement.getQuerySpec());
        return new SelectStatement(querySpec, this.domainResults);
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this;
    }

    @Override
    public List<Fetch> visitFetches(FetchParent fetchParent) {
        return Collections.emptyList();
    }
}

