/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.criteria.JpaFunction;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.sql.ast.tree.expression.Expression;

public abstract class SqmFunction<T>
extends AbstractSqmExpression<T>
implements JpaFunction<T>,
DomainResultProducer<T>,
SemanticPathPart {
    private final String functionName;
    private final SqmFunctionDescriptor functionDescriptor;
    private List<SqmTypedNode<?>> arguments;

    public SqmFunction(String functionName, SqmFunctionDescriptor functionDescriptor, SqmExpressable<T> type, NodeBuilder criteriaBuilder) {
        super(type, criteriaBuilder);
        this.functionName = functionName;
        this.functionDescriptor = functionDescriptor;
    }

    public SqmFunction(String functionName, SqmFunctionDescriptor functionDescriptor, SqmExpressable<T> type, List<SqmTypedNode<?>> arguments, NodeBuilder criteriaBuilder) {
        super(type, criteriaBuilder);
        this.functionName = functionName;
        this.functionDescriptor = functionDescriptor;
        this.arguments = arguments;
    }

    public SqmFunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    public List<SqmTypedNode<?>> getArguments() {
        return this.arguments;
    }

    public void addArgument(SqmTypedNode<?> argument) {
        assert (argument != null);
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        this.arguments.add(argument);
    }

    public abstract Expression convertToSqlAst(SqmToSqlAstConverter var1);

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitFunction(this);
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqmPath resolveIndexedAccess(SqmExpression selector, boolean isTerminal, SqmCreationState creationState) {
        throw new UnsupportedOperationException();
    }
}

