/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.Arrays;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.query.criteria.JpaCompoundSelection;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class SqmTuple<T>
extends AbstractSqmExpression<T>
implements JpaCompoundSelection<T> {
    private final List<SqmExpression<?>> groupedExpressions;

    public SqmTuple(NodeBuilder nodeBuilder, SqmExpression<?> ... groupedExpressions) {
        this(Arrays.asList(groupedExpressions), nodeBuilder);
    }

    public SqmTuple(NodeBuilder nodeBuilder, SqmExpressable<T> type, SqmExpression<?> ... groupedExpressions) {
        this(Arrays.asList(groupedExpressions), nodeBuilder);
        this.applyInferableType(type);
    }

    public SqmTuple(List<SqmExpression<?>> groupedExpressions, NodeBuilder nodeBuilder) {
        super(null, nodeBuilder);
        if (groupedExpressions.isEmpty()) {
            throw new QueryException("tuple grouping cannot be constructed over zero expressions");
        }
        this.groupedExpressions = groupedExpressions;
    }

    public SqmTuple(List<SqmExpression<?>> groupedExpressions, SqmExpressable<T> type, NodeBuilder nodeBuilder) {
        this(groupedExpressions, nodeBuilder);
        this.applyInferableType(type);
    }

    public List<SqmExpression<?>> getGroupedExpressions() {
        return this.groupedExpressions;
    }

    @Override
    public SqmExpressable<T> getNodeType() {
        SqmExpressable expressableType = super.getNodeType();
        if (expressableType != null) {
            return expressableType;
        }
        for (SqmExpression<?> groupedExpression : this.groupedExpressions) {
            SqmExpressable<?> groupedExpressionExpressableType = groupedExpression.getNodeType();
            if (groupedExpressionExpressableType == null) continue;
            return groupedExpressionExpressableType;
        }
        return null;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitTuple(this);
    }

    @Override
    public String asLoggableText() {
        return this.toString();
    }

    @Override
    public JavaTypeDescriptor<T> getJavaTypeDescriptor() {
        return this.getNodeType().getExpressableJavaTypeDescriptor();
    }

    @Override
    public boolean isCompoundSelection() {
        return true;
    }

    @Override
    public List<? extends JpaSelection<?>> getSelectionItems() {
        return this.getGroupedExpressions();
    }
}

