/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.AbstractNegatableSqmPredicate;

public class SqmComparisonPredicate
extends AbstractNegatableSqmPredicate {
    private final SqmExpression<?> leftHandExpression;
    private ComparisonOperator operator;
    private final SqmExpression<?> rightHandExpression;

    public SqmComparisonPredicate(SqmExpression<?> leftHandExpression, ComparisonOperator operator, SqmExpression<?> rightHandExpression, NodeBuilder nodeBuilder) {
        super(nodeBuilder);
        this.leftHandExpression = leftHandExpression;
        this.rightHandExpression = rightHandExpression;
        this.operator = operator;
        SqmExpressable expressableType = QueryHelper.highestPrecedenceType(leftHandExpression.getNodeType(), rightHandExpression.getNodeType());
        leftHandExpression.applyInferableType(expressableType);
        rightHandExpression.applyInferableType(expressableType);
    }

    public SqmExpression<?> getLeftHandExpression() {
        return this.leftHandExpression;
    }

    public SqmExpression<?> getRightHandExpression() {
        return this.rightHandExpression;
    }

    public ComparisonOperator getSqmOperator() {
        return this.operator;
    }

    @Override
    public boolean isNegated() {
        return false;
    }

    @Override
    public void negate() {
        this.operator = this.operator.negated();
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitComparisonPredicate(this);
    }
}

