/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.criteria.JpaSubQuery;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.domain.SqmBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmInPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.AbstractSqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class SqmSubQuery<T>
extends AbstractSqmSelectQuery<T>
implements SqmSelectQuery<T>,
JpaSubQuery<T>,
SqmExpression<T> {
    private final SqmQuery<?> parent;
    private SqmExpressable<T> expressableType;
    private String alias;

    public SqmSubQuery(SqmQuery<?> parent, SqmQuerySpec<T> querySpec, NodeBuilder builder) {
        super(querySpec, builder);
        this.parent = parent;
    }

    public SqmSubQuery(SqmQuery<?> parent, Class<T> resultType, NodeBuilder builder) {
        super(resultType, builder);
        this.parent = parent;
    }

    public SqmSubQuery(SqmQuery<?> parent, NodeBuilder builder) {
        super((Class)null, builder);
        this.parent = parent;
    }

    public SqmQuery<?> getContainingQuery() {
        return this.parent;
    }

    public SqmSelectQuery<?> getParent() {
        return (SqmSelectQuery)this.getContainingQuery();
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public SqmSubQuery<T> alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public SqmSubQuery<T> select(Expression<T> expression) {
        ((SqmQuerySpec)this.getQuerySpec()).setSelection((JpaSelection)expression);
        return this;
    }

    @Override
    public SqmExpression<T> getSelection() {
        return (SqmExpression)super.getSelection();
    }

    public boolean isCompoundSelection() {
        return ((SqmQuerySpec)this.getQuerySpec()).getSelection().isCompoundSelection();
    }

    @Override
    public List<? extends JpaSelection<?>> getSelectionItems() {
        return null;
    }

    @Override
    public List<Selection<?>> getCompoundSelectionItems() {
        if (!this.isCompoundSelection()) {
            throw new IllegalStateException("JPA selection is not compound");
        }
        return ((SqmQuerySpec)this.getQuerySpec()).getSelection().getCompoundSelectionItems();
    }

    @Override
    public SqmSubQuery<T> distinct(boolean distinct) {
        return (SqmSubQuery)super.distinct(distinct);
    }

    public <Y> SqmRoot<Y> correlate(Root<Y> parentRoot) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public SqmSubQuery<T> where(Expression<Boolean> restriction) {
        return (SqmSubQuery)super.where((Expression)restriction);
    }

    @Override
    public SqmSubQuery<T> where(Predicate ... restrictions) {
        return (SqmSubQuery)super.where(restrictions);
    }

    @Override
    public SqmSubQuery<T> groupBy(Expression<?> ... expressions) {
        return (SqmSubQuery)super.groupBy((Expression[])expressions);
    }

    @Override
    public SqmSubQuery<T> groupBy(List<Expression<?>> grouping) {
        return (SqmSubQuery)super.groupBy((List)grouping);
    }

    @Override
    public SqmSubQuery<T> having(Expression<Boolean> booleanExpression) {
        return (SqmSubQuery)super.having((Expression)booleanExpression);
    }

    @Override
    public SqmSubQuery<T> having(Predicate ... predicates) {
        return (SqmSubQuery)super.having(predicates);
    }

    public <X, Y> SqmSingularJoin<X, Y> correlate(Join<X, Y> parentJoin) {
        throw new NotYetImplementedFor6Exception();
    }

    public <X, Y> SqmBagJoin<X, Y> correlate(CollectionJoin<X, Y> parentCollection) {
        throw new NotYetImplementedFor6Exception();
    }

    public <X, Y> SqmSetJoin<X, Y> correlate(SetJoin<X, Y> parentSet) {
        throw new NotYetImplementedFor6Exception();
    }

    public <X, Y> SqmListJoin<X, Y> correlate(ListJoin<X, Y> parentList) {
        throw new NotYetImplementedFor6Exception();
    }

    public <X, K, V> SqmMapJoin<X, K, V> correlate(MapJoin<X, K, V> parentMap) {
        throw new NotYetImplementedFor6Exception();
    }

    public Set<Join<?, ?>> getCorrelatedJoins() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public SqmPredicate isNull() {
        return this.nodeBuilder().isNull(this);
    }

    @Override
    public SqmPredicate isNotNull() {
        return this.nodeBuilder().isNotNull(this);
    }

    @Override
    public SqmInPredicate in(Object ... values) {
        return this.nodeBuilder().in((Expression)this, values);
    }

    @Override
    public SqmInPredicate in(Expression<?> ... values) {
        return this.nodeBuilder().in((Expression)this, (Expression[])values);
    }

    @Override
    public SqmInPredicate in(Collection<?> values) {
        return this.nodeBuilder().in((Expression)this, new Object[]{values});
    }

    @Override
    public SqmInPredicate in(Expression<Collection<?>> values) {
        return this.nodeBuilder().in((Expression)this, new Expression[]{values});
    }

    @Override
    public SqmExpressable<T> getNodeType() {
        return this.expressableType;
    }

    @Override
    public void applyInferableType(SqmExpressable<?> type) {
    }

    @Override
    public SqmExpression<Long> asLong() {
        return this.castAs(StandardBasicTypes.LONG);
    }

    @Override
    public SqmExpression<Integer> asInteger() {
        return this.castAs(StandardBasicTypes.INTEGER);
    }

    @Override
    public SqmExpression<Float> asFloat() {
        return this.castAs(StandardBasicTypes.FLOAT);
    }

    @Override
    public SqmExpression<Double> asDouble() {
        return this.castAs(StandardBasicTypes.DOUBLE);
    }

    @Override
    public SqmExpression<BigDecimal> asBigDecimal() {
        return this.castAs(StandardBasicTypes.BIG_DECIMAL);
    }

    @Override
    public SqmExpression<BigInteger> asBigInteger() {
        return this.castAs(StandardBasicTypes.BIG_INTEGER);
    }

    @Override
    public SqmExpression<String> asString() {
        return this.castAs(StandardBasicTypes.STRING);
    }

    @Override
    public <X> SqmExpression<X> as(Class<X> type) {
        return this.nodeBuilder().cast((JpaExpression)this, (Class)type);
    }

    @Override
    public JavaTypeDescriptor<T> getJavaTypeDescriptor() {
        if (this.getNodeType() == null) {
            return null;
        }
        return this.getNodeType().getExpressableJavaTypeDescriptor();
    }

    @Override
    public Class<? extends T> getJavaType() {
        return this.getResultType();
    }

    public <U> SqmSubQuery<U> subquery(Class<U> type) {
        return new SqmSubQuery<U>(this, type, this.nodeBuilder());
    }

    @Override
    public String asLoggableText() {
        return "<sub-query>";
    }

    public <T1> T1 accept(SemanticQueryWalker<T1> walker) {
        return walker.visitSubQueryExpression(this);
    }
}

