/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast;

import java.util.Locale;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.SortOrder;
import org.hibernate.query.sqm.tree.expression.Conversion;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstTreeLogger;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.Any;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Duration;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.EntityTypeLiteral;
import org.hibernate.sql.ast.tree.expression.Every;
import org.hibernate.sql.ast.tree.expression.ExtractUnit;
import org.hibernate.sql.ast.tree.expression.Format;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Star;
import org.hibernate.sql.ast.tree.expression.TrimSpecification;
import org.hibernate.sql.ast.tree.expression.UnaryOperation;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.predicate.BetweenPredicate;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.GroupedPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NegatedPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.SelfRenderingPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;

public class SqlTreePrinter
implements SqlAstWalker {
    private final StringBuffer buffer = new StringBuffer();
    private int depth = 2;

    public static void print(Statement sqlAstStatement) {
        if (!SqlAstTreeLogger.DEBUG_ENABLED) {
            return;
        }
        SqlTreePrinter printer = new SqlTreePrinter();
        printer.visitStatement(sqlAstStatement);
        SqlAstTreeLogger.INSTANCE.debugf("SQL AST Tree:%n" + printer.buffer.toString(), new Object[0]);
    }

    private SqlTreePrinter() {
    }

    private void visitStatement(Statement sqlAstStatement) {
        if (sqlAstStatement instanceof SelectStatement) {
            this.logNode("select-statement", () -> this.visitQuerySpec(((SelectStatement)sqlAstStatement).getQuerySpec()));
        } else if (sqlAstStatement instanceof DeleteStatement) {
            DeleteStatement deleteStatement = (DeleteStatement)sqlAstStatement;
            this.logNode("delete-statement", () -> {
                this.logNode("target", () -> this.logNode(deleteStatement.getTargetTable().toString()));
                this.logNode("where", () -> {
                    if (deleteStatement.getRestriction() != null) {
                        deleteStatement.getRestriction().accept(this);
                    }
                });
            });
        } else if (sqlAstStatement instanceof UpdateStatement) {
            UpdateStatement updateStatement = (UpdateStatement)sqlAstStatement;
            this.logNode("update-statement", () -> {
                this.logNode("target", () -> this.logNode(updateStatement.getTargetTable().toString()));
                this.logNode("set", () -> {
                    for (Assignment assignment : updateStatement.getAssignments()) {
                        this.logNode("assignment", () -> assignment.accept(this), true);
                    }
                });
                this.logNode("where", () -> {
                    if (updateStatement.getRestriction() != null) {
                        updateStatement.getRestriction().accept(this);
                    }
                });
            });
        } else if (sqlAstStatement instanceof InsertStatement) {
            InsertStatement insertStatement = (InsertStatement)sqlAstStatement;
            this.logNode("insert-select-statement", () -> {
                this.logNode("target", () -> this.logNode(insertStatement.getTargetTable().toString()));
                this.logNode("into", () -> {
                    for (ColumnReference spec : insertStatement.getTargetColumnReferences()) {
                        this.logNode("target-column", () -> spec.accept(this));
                    }
                });
                this.logNode("select", () -> this.visitQuerySpec(insertStatement.getSourceSelectStatement()));
            });
        } else {
            throw new UnsupportedOperationException("Printing for this type of SQL AST not supported : " + sqlAstStatement);
        }
    }

    private void logNode(String text) {
        this.logWithIndentation("-> [%s]", (Object)text);
    }

    private void logNode(String pattern, Object arg) {
        this.logWithIndentation("-> [" + String.format(pattern, arg) + ']');
    }

    private void logNode(String pattern, Object arg, Object arg2) {
        this.logWithIndentation("-> [" + String.format(pattern, arg, arg2) + ']');
    }

    private void logNode(String text, Runnable subTreeHandler) {
        this.logNode(text, subTreeHandler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logNode(String text, Runnable subTreeHandler, boolean indentContinuation) {
        this.logWithIndentation("-> [%s]", (Object)text);
        ++this.depth;
        try {
            if (indentContinuation) {
                ++this.depth;
            }
            subTreeHandler.run();
        }
        catch (Exception e) {
            SqlAstTreeLogger.INSTANCE.debugf(e, "Error processing node {%s}", text);
        }
        finally {
            if (indentContinuation) {
                --this.depth;
            }
        }
        --this.depth;
        this.logWithIndentation("<- [%s]", (Object)text);
    }

    private void logWithIndentation(Object line) {
        this.pad(this.depth);
        this.buffer.append(line).append(System.lineSeparator());
    }

    private void logWithIndentation(String pattern, Object arg1) {
        this.logWithIndentation(String.format(pattern, arg1));
    }

    private void logWithIndentation(String pattern, Object arg1, Object arg2) {
        this.logWithIndentation(String.format(pattern, arg1, arg2));
    }

    private void logWithIndentation(String pattern, Object ... args) {
        this.logWithIndentation(String.format(pattern, args));
    }

    private void pad(int depth) {
        for (int i = 0; i < depth; ++i) {
            this.buffer.append("  ");
        }
    }

    @Override
    public void visitAssignment(Assignment assignment) {
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        this.logNode("query-spec", () -> {
            this.visitSelectClause(querySpec.getSelectClause());
            this.visitFromClause(querySpec.getFromClause());
            if (querySpec.getWhereClauseRestrictions() != null && !querySpec.getWhereClauseRestrictions().isEmpty()) {
                this.logNode("where", () -> querySpec.getWhereClauseRestrictions().accept(this));
            }
            if (!querySpec.getSortSpecifications().isEmpty()) {
                this.logNode("order-by", () -> {
                    for (SortSpecification sortSpecification : querySpec.getSortSpecifications()) {
                        this.visitSortSpecification(sortSpecification);
                    }
                });
            }
            if (querySpec.getLimitClauseExpression() != null) {
                this.logNode("limit", () -> querySpec.getLimitClauseExpression().accept(this));
            }
            if (querySpec.getOffsetClauseExpression() != null) {
                this.logNode("offset", () -> querySpec.getOffsetClauseExpression().accept(this));
            }
        });
    }

    @Override
    public void visitSortSpecification(SortSpecification sortSpecification) {
        this.logNode("sort", () -> {
            sortSpecification.getSortExpression().accept(this);
            this.logNode(sortSpecification.getSortOrder() == null ? SortOrder.ASCENDING.name() : sortSpecification.getSortOrder().name());
        });
    }

    @Override
    public void visitLimitOffsetClause(QuerySpec querySpec) {
        throw new UnsupportedOperationException("Unexpected call to #visitLimitOffsetClause");
    }

    @Override
    public void visitSelectClause(SelectClause selectClause) {
        this.logNode("select", () -> {
            for (SqlSelection sqlSelection : selectClause.getSqlSelections()) {
                this.visitSqlSelection(sqlSelection);
            }
        });
    }

    @Override
    public void visitSqlSelection(SqlSelection sqlSelection) {
        this.logWithIndentation("selection - " + sqlSelection);
    }

    @Override
    public void visitFromClause(FromClause fromClause) {
        this.logNode("from", () -> fromClause.visitRoots(this::visitTableGroup));
    }

    @Override
    public void visitTableGroup(TableGroup tableGroup) {
        this.logNode("table-group", () -> {
            this.visitTableReference(tableGroup.getPrimaryTableReference());
            for (TableReferenceJoin join : tableGroup.getTableReferenceJoins()) {
                this.visitTableReferenceJoin(join);
            }
            tableGroup.visitTableGroupJoins(this::visitTableGroupJoin);
        });
    }

    @Override
    public void visitTableGroupJoin(TableGroupJoin tableGroupJoin) {
        this.logNode("table-group-join", () -> {
            this.visitTableGroup(tableGroupJoin.getJoinedGroup());
            this.logNode(tableGroupJoin.getJoinType().getText());
            this.logNode("on", () -> tableGroupJoin.getPredicate().accept(this));
        });
    }

    @Override
    public void visitTableReference(TableReference tableReference) {
        this.logNode(tableReference.getTableExpression() + " as " + tableReference.getIdentificationVariable());
    }

    @Override
    public void visitTableReferenceJoin(TableReferenceJoin tableReferenceJoin) {
        this.logNode("join", () -> {
            this.visitTableReference(tableReferenceJoin.getJoinedTableReference());
            this.logNode(tableReferenceJoin.getJoinType().getText());
            this.logNode("on", () -> tableReferenceJoin.getJoinPredicate().accept(this));
        });
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        this.logNode("{%s}.{%s}", columnReference.getQualifier(), columnReference.getColumnExpression());
    }

    @Override
    public void visitExtractUnit(ExtractUnit extractUnit) {
        this.logNode(extractUnit.getUnit().toString());
    }

    @Override
    public void visitFormat(Format format) {
        this.logNode(format.getFormat());
    }

    @Override
    public void visitDistinct(Distinct distinct) {
        this.logNode("{distinct}");
    }

    @Override
    public void visitStar(Star star) {
        this.logNode("{*}");
    }

    @Override
    public void visitTrimSpecification(TrimSpecification trimSpecification) {
        this.logNode("{" + trimSpecification.getSpecification().toSqlText() + "}");
    }

    @Override
    public void visitCastTarget(CastTarget castTarget) {
        this.logNode("`" + castTarget.getExpressionType().getJdbcMapping().getSqlTypeDescriptor() + "`");
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression expression) {
        this.logNode(expression.getOperator().getOperatorSqlTextString(), () -> {
            expression.getLeftHandOperand().accept(this);
            expression.getRightHandOperand().accept(this);
        });
    }

    @Override
    public void visitSqlSelectionExpression(SqlSelectionExpression expression) {
        this.logNode("selection-reference (%s)", expression.getSelection().getJdbcResultSetIndex());
    }

    @Override
    public void visitEntityTypeLiteral(EntityTypeLiteral expression) {
    }

    @Override
    public void visitTuple(SqlTuple tuple) {
        this.logNode("tuple", () -> tuple.getExpressions().forEach(expr -> expr.accept(this)));
    }

    @Override
    public void visitParameter(JdbcParameter jdbcParameter) {
        this.logNode("parameter");
    }

    @Override
    public void visitCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public void visitCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public void visitAny(Any any) {
    }

    @Override
    public void visitEvery(Every every) {
    }

    @Override
    public void visitJdbcLiteral(JdbcLiteral jdbcLiteral) {
        this.logNode("literal (" + jdbcLiteral.getLiteralValue() + ')');
    }

    @Override
    public void visitQueryLiteral(QueryLiteral queryLiteral) {
        this.logNode("literal (" + queryLiteral.getLiteralValue() + ')');
    }

    @Override
    public void visitUnaryOperationExpression(UnaryOperation operation) {
        this.logNode(operation.getOperator().name().toLowerCase(Locale.ROOT), () -> operation.getOperand().accept(this));
    }

    @Override
    public void visitBetweenPredicate(BetweenPredicate betweenPredicate) {
        this.logNode("between", () -> {
            betweenPredicate.getExpression().accept(this);
            betweenPredicate.getLowerBound().accept(this);
            betweenPredicate.getUpperBound().accept(this);
        });
    }

    @Override
    public void visitFilterPredicate(FilterPredicate filterPredicate) {
        this.logNode("filter-predicate", () -> this.logNode(filterPredicate.getFilterFragment()));
    }

    @Override
    public void visitGroupedPredicate(GroupedPredicate groupedPredicate) {
        this.logNode("grouped-predicate", () -> groupedPredicate.getSubPredicate().accept(this));
    }

    @Override
    public void visitInListPredicate(InListPredicate inListPredicate) {
        this.logNode("in", () -> {
            inListPredicate.getTestExpression().accept(this);
            this.logNode("list", () -> inListPredicate.getListExpressions().forEach(expr -> expr.accept(this)));
        });
    }

    @Override
    public void visitInSubQueryPredicate(InSubQueryPredicate inSubQueryPredicate) {
        this.logNode("in", () -> {
            inSubQueryPredicate.getTestExpression().accept(this);
            this.visitQuerySpec(inSubQueryPredicate.getSubQuery());
        });
    }

    @Override
    public void visitExistsPredicate(ExistsPredicate existsPredicate) {
    }

    @Override
    public void visitJunction(Junction junction) {
        this.logNode(junction.getNature().name().toLowerCase(), () -> junction.getPredicates().forEach(predicate -> predicate.accept(this)));
    }

    @Override
    public void visitLikePredicate(LikePredicate likePredicate) {
        this.logNode("like", () -> {
            likePredicate.getMatchExpression().accept(this);
            likePredicate.getPattern().accept(this);
            if (likePredicate.getEscapeCharacter() != null) {
                likePredicate.getEscapeCharacter().accept(this);
            }
        });
    }

    @Override
    public void visitNegatedPredicate(NegatedPredicate negatedPredicate) {
        this.logNode("not", () -> negatedPredicate.getPredicate().accept(this));
    }

    @Override
    public void visitNullnessPredicate(NullnessPredicate nullnessPredicate) {
    }

    @Override
    public void visitRelationalPredicate(ComparisonPredicate comparisonPredicate) {
        this.logNode(comparisonPredicate.getOperator().name().toLowerCase(Locale.ROOT), () -> {
            comparisonPredicate.getLeftHandExpression().accept(this);
            comparisonPredicate.getRightHandExpression().accept(this);
        });
    }

    @Override
    public void visitSelfRenderingPredicate(SelfRenderingPredicate selfRenderingPredicate) {
    }

    @Override
    public void visitSelfRenderingExpression(SelfRenderingExpression expression) {
    }

    @Override
    public void visitDurationUnit(DurationUnit durationUnit) {
    }

    @Override
    public void visitDuration(Duration duration) {
    }

    @Override
    public void visitConversion(Conversion conversion) {
    }
}

