/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlTreeCreationException;
import org.hibernate.sql.ast.spi.AbstractSqlAstWalker;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignment;

public abstract class AbstractSqlAstTranslator
extends AbstractSqlAstWalker
implements SqlAstTranslator {
    private final Set<String> affectedTableNames = new HashSet<String>();

    protected AbstractSqlAstTranslator(SessionFactoryImplementor sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public void visitAssignment(Assignment assignment) {
        throw new SqlTreeCreationException("Encountered unexpected assignment clause");
    }

    @Override
    public Set<String> getAffectedTableNames() {
        return this.affectedTableNames;
    }

    @Override
    protected void renderTableReference(TableReference tableReference) {
        super.renderTableReference(tableReference);
        this.registerAffectedTable(tableReference);
    }

    protected void registerAffectedTable(TableReference tableReference) {
        this.registerAffectedTable(tableReference.getTableExpression());
    }

    protected void registerAffectedTable(String tableExpression) {
        this.affectedTableNames.add(tableExpression);
    }
}

