/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.List;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.SqlAstDeleteTranslator;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;

public class StandardSqlAstDeleteTranslator
extends AbstractSqlAstTranslator
implements SqlAstDeleteTranslator {
    public StandardSqlAstDeleteTranslator(SessionFactoryImplementor sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public JdbcDelete translate(DeleteStatement sqlAst) {
        this.appendSql("delete from ");
        this.appendSql(sqlAst.getTargetTable().getTableExpression());
        if (sqlAst.getRestriction() != null) {
            this.appendSql(" where ");
            sqlAst.getRestriction().accept(this);
        }
        return new JdbcDelete(){

            @Override
            public String getSql() {
                return StandardSqlAstDeleteTranslator.this.getSql();
            }

            @Override
            public List<JdbcParameterBinder> getParameterBinders() {
                return StandardSqlAstDeleteTranslator.this.getParameterBinders();
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return StandardSqlAstDeleteTranslator.this.getAffectedTableNames();
            }
        };
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        this.appendSql(columnReference.getColumnExpression());
    }

    @Override
    public JdbcDelete translate(CteStatement sqlAst) {
        assert (sqlAst.getCteConsumer() instanceof DeleteStatement);
        this.appendSql("with ");
        this.appendSql(sqlAst.getCteLabel());
        this.appendSql(" (");
        String separator = "";
        for (CteColumn cteColumn : sqlAst.getCteTable().getCteColumns()) {
            this.appendSql(separator);
            this.appendSql(cteColumn.getColumnExpression());
            separator = ", ";
        }
        this.appendSql(") as (");
        this.visitQuerySpec(sqlAst.getCteDefinition());
        this.appendSql(") ");
        this.translate((DeleteStatement)sqlAst.getCteConsumer());
        return new JdbcDelete(){

            @Override
            public String getSql() {
                return StandardSqlAstDeleteTranslator.this.getSql();
            }

            @Override
            public List<JdbcParameterBinder> getParameterBinders() {
                return StandardSqlAstDeleteTranslator.this.getParameterBinders();
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return StandardSqlAstDeleteTranslator.this.getAffectedTableNames();
            }
        };
    }
}

