/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.Collections;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.SqlAstSelectTranslator;
import org.hibernate.sql.ast.SqlTreePrinter;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.SqlAstTreeLogger;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesMappingProducerStandard;

public class StandardSqlAstSelectTranslator
extends AbstractSqlAstTranslator
implements SqlAstSelectTranslator {
    public StandardSqlAstSelectTranslator(SessionFactoryImplementor sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public JdbcSelect translate(CteStatement sqlAst) {
        assert (sqlAst.getCteConsumer() instanceof QuerySpec);
        this.appendSql("with ");
        this.appendSql(sqlAst.getCteLabel());
        this.appendSql(" (");
        String separator = "";
        for (CteColumn cteColumn : sqlAst.getCteTable().getCteColumns()) {
            this.appendSql(separator);
            this.appendSql(cteColumn.getColumnExpression());
            separator = ", ";
        }
        this.appendSql(") as (");
        this.visitQuerySpec(sqlAst.getCteDefinition());
        this.appendSql(") ");
        this.translate((QuerySpec)sqlAst.getCteConsumer());
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public JdbcSelect translate(QuerySpec querySpec) {
        this.visitQuerySpec(querySpec);
        return new JdbcSelect(this.getSql(), this.getParameterBinders(), new JdbcValuesMappingProducerStandard(querySpec.getSelectClause().getSqlSelections(), Collections.emptyList()), this.getAffectedTableNames(), this.filterJdbcParameters);
    }

    @Override
    public JdbcSelect translate(SelectStatement sqlAstSelect) {
        if (SqlAstTreeLogger.DEBUG_ENABLED) {
            SqlTreePrinter.print(sqlAstSelect);
        }
        this.visitQuerySpec(sqlAstSelect.getQuerySpec());
        return new JdbcSelect(this.getSql(), this.getParameterBinders(), new JdbcValuesMappingProducerStandard(sqlAstSelect.getQuerySpec().getSelectClause().getSqlSelections(), sqlAstSelect.getDomainResultDescriptors()), this.getAffectedTableNames(), this.filterJdbcParameters);
    }
}

