/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.cte;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteTableGroup;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;

public class CteTable {
    private final SessionFactoryImplementor sessionFactory;
    private final List<CteColumn> cteColumns;

    public CteTable(EntityMappingType entityDescriptor) {
        this.sessionFactory = entityDescriptor.getEntityPersister().getFactory();
        int numberOfColumns = entityDescriptor.getIdentifierMapping().getJdbcTypeCount(this.sessionFactory.getTypeConfiguration());
        this.cteColumns = new ArrayList<CteColumn>(numberOfColumns);
        entityDescriptor.getIdentifierMapping().visitColumns((containingTableExpression, columnExpression, jdbcMapping) -> this.cteColumns.add(new CteColumn("cte_" + columnExpression, jdbcMapping)));
    }

    public CteTable(List<CteColumn> cteColumns, SessionFactoryImplementor sessionFactory) {
        this.cteColumns = cteColumns;
        this.sessionFactory = sessionFactory;
    }

    public String getTableExpression() {
        return "id_cte";
    }

    public List<CteColumn> getCteColumns() {
        return this.cteColumns;
    }

    public QuerySpec createCteDefinition(List<?> matchingIds, Bindable bindable, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        QuerySpec querySpec = new QuerySpec(false);
        TableReference tableValueConstructorReference = this.createCteDefinitionTableValueCtor(matchingIds, bindable, jdbcParameterBindings, executionContext);
        StandardTableGroup tableValueCtorGroup = new StandardTableGroup(new NavigablePath("cte"), null, LockMode.NONE, tableValueConstructorReference, Collections.emptyList(), null, this.sessionFactory);
        querySpec.getFromClause().addRoot(tableValueCtorGroup);
        this.applySelections(querySpec, tableValueConstructorReference);
        return querySpec;
    }

    private TableReference createCteDefinitionTableValueCtor(List<?> matchingValues, Bindable bindable, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        int numberOfColumns = this.getCteColumns().size();
        StringBuilder tableValueCtorExpressionBuffer = new StringBuilder("values(");
        String rowSeparator = "";
        for (Object matchingId : matchingValues) {
            tableValueCtorExpressionBuffer.append(rowSeparator);
            tableValueCtorExpressionBuffer.append('(');
            StringHelper.repeat("?", numberOfColumns, ",", tableValueCtorExpressionBuffer);
            tableValueCtorExpressionBuffer.append(')');
            bindable.visitJdbcValues(matchingId, Clause.IRRELEVANT, (value, type) -> {
                JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(type);
                JdbcParameterBinding jdbcParameterBinding = new JdbcParameterBinding(){

                    @Override
                    public JdbcMapping getBindType() {
                        return type;
                    }

                    @Override
                    public Object getBindValue() {
                        return value;
                    }
                };
                jdbcParameterBindings.addBinding(jdbcParameter, jdbcParameterBinding);
            }, executionContext.getSession());
            rowSeparator = ", ";
        }
        tableValueCtorExpressionBuffer.append(')');
        return new TableReference(tableValueCtorExpressionBuffer.toString(), "id_cte", false, this.sessionFactory);
    }

    public QuerySpec createCteSubQuery(ExecutionContext executionContext) {
        QuerySpec querySpec = new QuerySpec(false);
        TableReference cteTableReference = new TableReference(this.getTableExpression(), null, false, this.sessionFactory);
        CteTableGroup cteTableGroup = new CteTableGroup(cteTableReference);
        querySpec.getFromClause().addRoot(cteTableGroup);
        this.applySelections(querySpec, cteTableReference);
        return querySpec;
    }

    private void applySelections(QuerySpec querySpec, TableReference tableReference) {
        for (int i = 0; i < this.cteColumns.size(); ++i) {
            CteColumn cteColumn = this.cteColumns.get(i);
            querySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(i + 1, i, new ColumnReference(tableReference, cteColumn.getColumnExpression(), cteColumn.getJdbcMapping(), this.sessionFactory)));
        }
    }
}

