/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public class CaseSimpleExpression
implements Expression,
DomainResultProducer {
    private final MappingModelExpressable type;
    private final Expression fixture;
    private List<WhenFragment> whenFragments = new ArrayList<WhenFragment>();
    private Expression otherwise;

    public CaseSimpleExpression(MappingModelExpressable type, Expression fixture) {
        this.type = type;
        this.fixture = fixture;
    }

    public CaseSimpleExpression(MappingModelExpressable type, Expression fixture, List<WhenFragment> whenFragments, Expression otherwise) {
        this.type = type;
        this.fixture = fixture;
        this.whenFragments = whenFragments;
        this.otherwise = otherwise;
    }

    public Expression getFixture() {
        return this.fixture;
    }

    @Override
    public MappingModelExpressable getExpressionType() {
        return this.type;
    }

    @Override
    public void accept(SqlAstWalker walker) {
        walker.visitCaseSimpleExpression(this);
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    public List<WhenFragment> getWhenFragments() {
        return this.whenFragments;
    }

    public Expression getOtherwise() {
        return this.otherwise;
    }

    public void otherwise(Expression otherwiseExpression) {
        this.otherwise = otherwiseExpression;
    }

    public void when(Expression test, Expression result) {
        this.whenFragments.add(new WhenFragment(test, result));
    }

    public static class WhenFragment {
        private final Expression checkValue;
        private final Expression result;

        public WhenFragment(Expression checkValue, Expression result) {
            this.checkValue = checkValue;
            this.result = result;
        }

        public Expression getCheckValue() {
            return this.checkValue;
        }

        public Expression getResult() {
            return this.result;
        }
    }
}

