/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignable;

public class ColumnReference
implements Expression,
Assignable {
    private final String qualifier;
    private final String columnExpression;
    private final String referenceExpression;
    private final JdbcMapping jdbcMapping;

    public ColumnReference(String qualifier, String columnExpression, JdbcMapping jdbcMapping, SessionFactoryImplementor sessionFactory) {
        this.qualifier = StringHelper.nullIfEmpty(qualifier);
        this.columnExpression = columnExpression;
        this.referenceExpression = this.qualifier == null ? columnExpression : this.qualifier + "." + columnExpression;
        this.jdbcMapping = jdbcMapping;
    }

    public ColumnReference(TableReference tableReference, String columnExpression, JdbcMapping jdbcMapping, SessionFactoryImplementor sessionFactory) {
        this(tableReference.getIdentificationVariable(), columnExpression, jdbcMapping, sessionFactory);
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getColumnExpression() {
        return this.columnExpression;
    }

    public String getExpressionText() {
        return this.referenceExpression;
    }

    public String renderSqlFragment(SessionFactoryImplementor sessionFactory) {
        return this.getExpressionText();
    }

    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public MappingModelExpressable getExpressionType() {
        return (MappingModelExpressable)((Object)this.jdbcMapping);
    }

    @Override
    public void accept(SqlAstWalker interpreter) {
        interpreter.visitColumnReference(this);
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s(%s)", this.getClass().getSimpleName(), this.referenceExpression);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnReference that = (ColumnReference)o;
        return Objects.equals(this.referenceExpression, that.referenceExpression);
    }

    public int hashCode() {
        return this.referenceExpression.hashCode();
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        columnReferenceConsumer.accept(this);
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        return Collections.singletonList(this);
    }
}

