/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.from.AbstractColumnReferenceQualifier;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;

public abstract class AbstractTableGroup
extends AbstractColumnReferenceQualifier
implements TableGroup {
    private final NavigablePath navigablePath;
    private final TableGroupProducer producer;
    private final LockMode lockMode;
    private final SqlAliasBase sqlAliasBase;
    private Set<TableGroupJoin> tableGroupJoins;
    private boolean isInnerJoinPossible;
    private final SessionFactoryImplementor sessionFactory;

    public AbstractTableGroup(NavigablePath navigablePath, TableGroupProducer producer, LockMode lockMode, SqlAliasBase sqlAliasBase, SessionFactoryImplementor sessionFactory) {
        this(navigablePath, producer, lockMode, sqlAliasBase, false, sessionFactory);
    }

    public AbstractTableGroup(NavigablePath navigablePath, TableGroupProducer producer, LockMode lockMode, SqlAliasBase sqlAliasBase, boolean isInnerJoinPossible, SessionFactoryImplementor sessionFactory) {
        this.navigablePath = navigablePath;
        this.producer = producer;
        this.lockMode = lockMode;
        this.sqlAliasBase = sqlAliasBase;
        this.isInnerJoinPossible = isInnerJoinPossible;
        this.sessionFactory = sessionFactory;
    }

    public SqlAliasBase getSqlAliasBase() {
        return this.sqlAliasBase;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public String getGroupAlias() {
        return this.sqlAliasBase.getAliasStem();
    }

    @Override
    public TableGroupProducer getModelPart() {
        return this.producer;
    }

    @Override
    public ModelPart getExpressionType() {
        return this.getModelPart();
    }

    @Override
    public LockMode getLockMode() {
        return this.lockMode;
    }

    @Override
    protected SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public Set<TableGroupJoin> getTableGroupJoins() {
        return this.tableGroupJoins == null ? Collections.emptySet() : Collections.unmodifiableSet(this.tableGroupJoins);
    }

    @Override
    public boolean hasTableGroupJoins() {
        return this.tableGroupJoins != null && !this.tableGroupJoins.isEmpty();
    }

    @Override
    public void setTableGroupJoins(Set<TableGroupJoin> joins) {
        if (this.tableGroupJoins == null) {
            this.tableGroupJoins = new HashSet<TableGroupJoin>(joins);
        } else {
            this.tableGroupJoins.addAll(joins);
        }
    }

    @Override
    public void addTableGroupJoin(TableGroupJoin join) {
        if (this.tableGroupJoins == null) {
            this.tableGroupJoins = new HashSet<TableGroupJoin>();
        }
        this.tableGroupJoins.add(join);
    }

    @Override
    public void visitTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.tableGroupJoins != null) {
            this.tableGroupJoins.forEach(consumer);
        }
    }

    @Override
    public boolean isInnerJoinPossible() {
        return this.isInnerJoinPossible;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.getNavigablePath() + ')';
    }
}

