/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.from.TableGroup;

public class FromClause
implements SqlAstNode {
    private final List<TableGroup> roots;

    public FromClause() {
        this.roots = new ArrayList<TableGroup>();
    }

    public FromClause(int expectedNumberOfRoots) {
        this.roots = CollectionHelper.arrayList(expectedNumberOfRoots);
    }

    public List<TableGroup> getRoots() {
        return this.roots;
    }

    public void addRoot(TableGroup tableGroup) {
        this.roots.add(tableGroup);
    }

    public void visitRoots(Consumer<TableGroup> action) {
        this.roots.forEach(action);
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitFromClause(this);
    }
}

