/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class TableReferenceJoin
implements SqlAstNode {
    private final SqlAstJoinType sqlAstJoinType;
    private final TableReference joinedTableBinding;
    private final Predicate predicate;

    public TableReferenceJoin(SqlAstJoinType sqlAstJoinType, TableReference joinedTableBinding, Predicate predicate) {
        this.sqlAstJoinType = sqlAstJoinType == null ? SqlAstJoinType.LEFT : sqlAstJoinType;
        this.joinedTableBinding = joinedTableBinding;
        this.predicate = predicate;
    }

    public SqlAstJoinType getJoinType() {
        return this.sqlAstJoinType;
    }

    public TableReference getJoinedTableReference() {
        return this.joinedTableBinding;
    }

    public Predicate getJoinPredicate() {
        return this.predicate;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitTableReferenceJoin(this);
    }

    public String toString() {
        return this.getJoinType().getText() + " join " + this.getJoinedTableReference().toString();
    }
}

