/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.spi;

import java.util.List;
import java.util.Set;
import org.hibernate.internal.FilterJdbcParameter;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;

public class JdbcSelect
implements JdbcOperation {
    private final String sql;
    private final List<JdbcParameterBinder> parameterBinders;
    private final JdbcValuesMappingProducer jdbcValuesMappingProducer;
    private final Set<String> affectedTableNames;
    private final List<FilterJdbcParameter> filterJdbcParameters;

    public JdbcSelect(String sql, List<JdbcParameterBinder> parameterBinders, JdbcValuesMappingProducer jdbcValuesMappingProducer, Set<String> affectedTableNames, List<FilterJdbcParameter> filterJdbcParameters) {
        this.sql = sql;
        this.parameterBinders = parameterBinders;
        this.jdbcValuesMappingProducer = jdbcValuesMappingProducer;
        this.affectedTableNames = affectedTableNames;
        this.filterJdbcParameters = filterJdbcParameters;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public List<JdbcParameterBinder> getParameterBinders() {
        return this.parameterBinders;
    }

    @Override
    public Set<String> getAffectedTableNames() {
        return this.affectedTableNames;
    }

    public JdbcValuesMappingProducer getJdbcValuesMappingProducer() {
        return this.jdbcValuesMappingProducer;
    }

    public void registerFilterJdbcParameterBindings(JdbcParameterBindings jdbcParameterBindings) {
        if (CollectionHelper.isNotEmpty(this.filterJdbcParameters)) {
            for (FilterJdbcParameter filterJdbcParameter : this.filterJdbcParameters) {
                jdbcParameterBindings.addBinding(filterJdbcParameter.getParameter(), filterJdbcParameter.getBinding());
            }
        }
    }
}

