/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph;

import java.util.Collections;
import java.util.List;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public abstract class AbstractFetchParent
implements FetchParent {
    private final FetchableContainer fetchContainer;
    private final NavigablePath navigablePath;
    protected List<Fetch> fetches;

    public AbstractFetchParent(FetchableContainer fetchContainer, NavigablePath navigablePath) {
        this.fetchContainer = fetchContainer;
        this.navigablePath = navigablePath;
    }

    protected void afterInitialize(DomainResultCreationState creationState) {
        this.fetches = creationState.visitFetches(this);
    }

    public FetchableContainer getFetchContainer() {
        return this.fetchContainer;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public JavaTypeDescriptor getResultJavaTypeDescriptor() {
        return this.fetchContainer.getJavaTypeDescriptor();
    }

    @Override
    public FetchableContainer getReferencedMappingContainer() {
        return this.fetchContainer;
    }

    @Override
    public List<Fetch> getFetches() {
        return this.fetches == null ? Collections.emptyList() : Collections.unmodifiableList(this.fetches);
    }

    @Override
    public Fetch findFetch(String fetchableName) {
        if (this.fetches != null) {
            for (Fetch fetch : this.fetches) {
                Fetchable fetchedMapping = fetch.getFetchedMapping();
                if (fetchedMapping == null || !fetchedMapping.getFetchableName().equals(fetchableName)) continue;
                return fetch;
            }
        }
        return null;
    }
}

