/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph;

import java.util.List;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultGraphNode;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.jboss.logging.Logger;

public class DomainResultGraphPrinter {
    private static final Logger log = Logger.getLogger(DomainResultGraphPrinter.class);
    private final StringBuilder buffer = new StringBuilder("DomainResult Graph:\n");
    private final Stack<FetchParent> fetchParentStack = new StandardStack<FetchParent>();

    public static void print(List<DomainResult> domainResults) {
        if (!log.isDebugEnabled()) {
            return;
        }
        DomainResultGraphPrinter graphPrinter = new DomainResultGraphPrinter();
        graphPrinter.visitDomainResults(domainResults);
    }

    private DomainResultGraphPrinter() {
    }

    private void visitDomainResults(List<DomainResult> domainResults) {
        for (int i = 0; i < domainResults.size(); ++i) {
            DomainResult domainResult = domainResults.get(i);
            assert (this.fetchParentStack.isEmpty());
            boolean lastInBranch = i + 1 == domainResults.size();
            this.visitGraphNode(domainResult, lastInBranch);
        }
        log.debug((Object)this.buffer.toString());
    }

    private void visitGraphNode(DomainResultGraphNode node, boolean lastInBranch) {
        this.indentLine();
        if (lastInBranch) {
            this.buffer.append(" \\-");
        } else {
            this.buffer.append(" +-");
        }
        this.buffer.append(node.getClass().getSimpleName());
        if (node.getNavigablePath() != null) {
            this.buffer.append(" [").append(node.getNavigablePath().getFullPath()).append("]");
        }
        this.buffer.append('\n');
        if (node instanceof FetchParent) {
            this.visitFetches((FetchParent)node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitFetches(FetchParent fetchParent) {
        this.fetchParentStack.push(fetchParent);
        try {
            int numberOfFetches = fetchParent.getFetches().size();
            for (int i = 0; i < numberOfFetches; ++i) {
                Fetch fetch = fetchParent.getFetches().get(i);
                boolean lastInBranch = i + 1 == numberOfFetches;
                this.visitGraphNode(fetch, lastInBranch);
            }
        }
        finally {
            this.fetchParentStack.pop();
        }
    }

    private void indentLine() {
        this.fetchParentStack.visitRootFirst(fetchParent -> {
            boolean hasSubFetches;
            boolean bl = hasSubFetches = !fetchParent.getFetches().isEmpty();
            if (hasSubFetches) {
                this.buffer.append(" | ");
            } else {
                this.buffer.append("   ");
            }
        });
    }
}

