/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.basic;

import java.util.function.Consumer;
import org.hibernate.Internal;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.basic.BasicResultGraphNode;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class BasicResult<T>
implements DomainResult<T>,
BasicResultGraphNode<T> {
    private final String resultVariable;
    private final JavaTypeDescriptor<T> javaTypeDescriptor;
    private final NavigablePath navigablePath;
    private final DomainResultAssembler<T> assembler;

    public BasicResult(int jdbcValuesArrayPosition, String resultVariable, JavaTypeDescriptor<T> javaTypeDescriptor) {
        this(jdbcValuesArrayPosition, resultVariable, javaTypeDescriptor, (NavigablePath)null);
    }

    public BasicResult(int jdbcValuesArrayPosition, String resultVariable, JavaTypeDescriptor<T> javaTypeDescriptor, NavigablePath navigablePath) {
        this.resultVariable = resultVariable;
        this.javaTypeDescriptor = javaTypeDescriptor;
        this.navigablePath = navigablePath;
        this.assembler = new BasicResultAssembler<T>(jdbcValuesArrayPosition, javaTypeDescriptor);
    }

    public BasicResult(int valuesArrayPosition, String resultVariable, JavaTypeDescriptor<T> javaTypeDescriptor, BasicValueConverter<T, ?> valueConverter) {
        this(valuesArrayPosition, resultVariable, javaTypeDescriptor, valueConverter, null);
    }

    public BasicResult(int valuesArrayPosition, String resultVariable, JavaTypeDescriptor<T> javaTypeDescriptor, BasicValueConverter<T, ?> valueConverter, NavigablePath navigablePath) {
        this.resultVariable = resultVariable;
        this.javaTypeDescriptor = javaTypeDescriptor;
        this.navigablePath = navigablePath;
        this.assembler = new BasicResultAssembler<T>(valuesArrayPosition, javaTypeDescriptor, valueConverter);
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public JavaTypeDescriptor getResultJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Internal
    public DomainResultAssembler<T> getAssembler() {
        return this.assembler;
    }

    @Override
    public DomainResultAssembler<T> createResultAssembler(Consumer<Initializer> initializerCollector, AssemblerCreationState creationState) {
        return this.assembler;
    }
}

