/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.basic;

import java.util.Locale;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class BasicResultAssembler<J>
implements DomainResultAssembler<J> {
    private final int valuesArrayPosition;
    private final JavaTypeDescriptor<J> assembledJavaTypeDescriptor;
    private final BasicValueConverter<J, ?> valueConverter;

    public static <X> BasicResultAssembler<X> from(SqlSelection selection, JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicResultAssembler<X>(selection.getValuesArrayPosition(), javaTypeDescriptor);
    }

    public BasicResultAssembler(int valuesArrayPosition, JavaTypeDescriptor<J> assembledJavaTypeDescriptor) {
        this(valuesArrayPosition, assembledJavaTypeDescriptor, null);
    }

    public BasicResultAssembler(int valuesArrayPosition, JavaTypeDescriptor<J> assembledJavaTypeDescriptor, BasicValueConverter<J, ?> valueConverter) {
        this.valuesArrayPosition = valuesArrayPosition;
        this.assembledJavaTypeDescriptor = assembledJavaTypeDescriptor;
        this.valueConverter = valueConverter;
    }

    public Object extractRawValue(RowProcessingState rowProcessingState) {
        return rowProcessingState.getJdbcValue(this.valuesArrayPosition);
    }

    @Override
    public J assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        Object jdbcValue = this.extractRawValue(rowProcessingState);
        ResultsLogger.INSTANCE.debugf("Extracted JDBC value [%d] - [%s]", this.valuesArrayPosition, jdbcValue);
        if (this.valueConverter != null) {
            if (jdbcValue != null && !this.valueConverter.getRelationalJavaDescriptor().getJavaType().isInstance(jdbcValue)) {
                throw new HibernateException(String.format(Locale.ROOT, "Expecting raw JDBC value of type `%s`, but found `%s` : [%s]", this.valueConverter.getRelationalJavaDescriptor().getJavaType().getName(), jdbcValue.getClass().getName(), jdbcValue));
            }
            return this.valueConverter.toDomainValue(jdbcValue);
        }
        return (J)jdbcValue;
    }

    @Override
    public JavaTypeDescriptor<J> getAssembledJavaTypeDescriptor() {
        return this.assembledJavaTypeDescriptor;
    }

    @Internal
    public BasicValueConverter<J, ?> getValueConverter() {
        return this.valueConverter;
    }
}

