/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableAssembler;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableResultInitializer;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class EmbeddableResultImpl<T>
extends AbstractFetchParent
implements EmbeddableResultGraphNode,
DomainResult<T> {
    private final String resultVariable;

    public EmbeddableResultImpl(NavigablePath navigablePath, EmbeddableValuedModelPart modelPart, String resultVariable, DomainResultCreationState creationState) {
        super(modelPart.getEmbeddableTypeDescriptor(), navigablePath);
        this.resultVariable = resultVariable;
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        fromClauseAccess.resolveTableGroup(navigablePath, np -> {
            EmbeddableValuedModelPart embeddedValueMapping = modelPart.getEmbeddableTypeDescriptor().getEmbeddedValueMapping();
            TableGroupJoin tableGroupJoin = embeddedValueMapping.createTableGroupJoin(navigablePath, fromClauseAccess.findTableGroup(navigablePath.getParent()), resultVariable, SqlAstJoinType.INNER, LockMode.NONE, creationState.getSqlAstCreationState().getSqlAliasBaseGenerator(), creationState.getSqlAstCreationState().getSqlExpressionResolver(), creationState.getSqlAstCreationState().getCreationContext());
            return tableGroupJoin.getJoinedGroup();
        });
        this.afterInitialize(creationState);
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public EmbeddableMappingType getFetchContainer() {
        return (EmbeddableMappingType)super.getFetchContainer();
    }

    @Override
    public JavaTypeDescriptor getResultJavaTypeDescriptor() {
        return this.getReferencedMappingType().getJavaTypeDescriptor();
    }

    @Override
    public EmbeddableMappingType getReferencedMappingType() {
        return this.getFetchContainer();
    }

    @Override
    public EmbeddableValuedModelPart getReferencedMappingContainer() {
        return this.getFetchContainer().getEmbeddedValueMapping();
    }

    @Override
    public DomainResultAssembler<T> createResultAssembler(Consumer<Initializer> initializerCollector, AssemblerCreationState creationState) {
        EmbeddableResultInitializer initializer = new EmbeddableResultInitializer(this, initializerCollector, creationState);
        initializerCollector.accept(initializer);
        return new EmbeddableAssembler(initializer);
    }
}

