/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity;

import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public abstract class AbstractEntityResultGraphNode
extends AbstractFetchParent
implements EntityResultGraphNode {
    private final EntityValuedModelPart referencedModelPart;
    private final DomainResult identifierResult;
    private final DomainResult discriminatorResult;
    private final DomainResult versionResult;
    private final LockMode lockMode;
    private final EntityMappingType targetType;

    public AbstractEntityResultGraphNode(EntityValuedModelPart referencedModelPart, LockMode lockMode, NavigablePath navigablePath, DomainResultCreationState creationState) {
        this(referencedModelPart, lockMode, navigablePath, null, creationState);
    }

    public AbstractEntityResultGraphNode(EntityValuedModelPart referencedModelPart, LockMode lockMode, NavigablePath navigablePath, EntityMappingType targetType, DomainResultCreationState creationState) {
        super(referencedModelPart.getEntityMappingType(), navigablePath);
        this.referencedModelPart = referencedModelPart;
        this.lockMode = lockMode;
        this.targetType = targetType;
        EntityMappingType entityDescriptor = referencedModelPart.getEntityMappingType();
        TableGroup entityTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(navigablePath);
        this.identifierResult = entityDescriptor.getIdentifierMapping().createDomainResult(navigablePath.append("{id}"), entityTableGroup, null, creationState);
        EntityDiscriminatorMapping discriminatorMapping = this.getDiscriminatorMapping(entityDescriptor, entityTableGroup);
        this.discriminatorResult = discriminatorMapping != null ? discriminatorMapping.createDomainResult(navigablePath.append("{discriminator}"), entityTableGroup, null, creationState) : null;
        EntityVersionMapping versionDescriptor = entityDescriptor.getVersionMapping();
        this.versionResult = versionDescriptor == null ? null : versionDescriptor.createDomainResult(navigablePath.append(versionDescriptor.getFetchableName()), entityTableGroup, null, creationState);
    }

    protected EntityDiscriminatorMapping getDiscriminatorMapping(EntityMappingType entityDescriptor, TableGroup entityTableGroup) {
        return entityDescriptor.getDiscriminatorMapping();
    }

    @Override
    public EntityMappingType getReferencedMappingContainer() {
        return this.getEntityValuedModelPart().getEntityMappingType();
    }

    @Override
    public EntityValuedModelPart getEntityValuedModelPart() {
        return this.referencedModelPart;
    }

    @Override
    public JavaTypeDescriptor getResultJavaTypeDescriptor() {
        return this.getEntityValuedModelPart().getEntityMappingType().getMappedJavaTypeDescriptor();
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public DomainResult getIdentifierResult() {
        return this.identifierResult;
    }

    public DomainResult getDiscriminatorResult() {
        return this.discriminatorResult;
    }

    public DomainResult getVersionResult() {
        return this.versionResult;
    }
}

