/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.internal.SingularAssociationAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.internal.AbstractNonJoinedEntityFetch;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchDelayedInitializer;

public class EntityFetchDelayedImpl
extends AbstractNonJoinedEntityFetch {
    private final LockMode lockMode;
    private final boolean nullable;
    private final DomainResult keyResult;

    public EntityFetchDelayedImpl(FetchParent fetchParent, SingularAssociationAttributeMapping fetchedAttribute, LockMode lockMode, boolean nullable, NavigablePath navigablePath, DomainResult keyResult) {
        super(navigablePath, fetchedAttribute, fetchParent);
        this.lockMode = lockMode;
        this.nullable = nullable;
        this.keyResult = keyResult;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.DELAYED;
    }

    @Override
    public boolean hasTableGroup() {
        return false;
    }

    @Override
    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, Consumer<Initializer> collector, AssemblerCreationState creationState) {
        EntityFetchDelayedInitializer entityInitializer = new EntityFetchDelayedInitializer(this.getNavigablePath(), this.getEntityValuedModelPart().getEntityMappingType().getEntityPersister(), this.keyResult.createResultAssembler(collector, creationState));
        collector.accept(entityInitializer);
        return new EntityAssembler(this.getFetchedMapping().getJavaTypeDescriptor(), entityInitializer);
    }
}

