/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class EntityFetchDelayedInitializer
extends AbstractFetchParentAccess
implements EntityInitializer {
    private final NavigablePath navigablePath;
    private final EntityPersister concreteDescriptor;
    private final DomainResultAssembler identifierAssembler;
    private Object entityInstance;
    private Object identifier;

    protected EntityFetchDelayedInitializer(NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResultAssembler identifierAssembler) {
        this.navigablePath = fetchedNavigable;
        this.concreteDescriptor = concreteDescriptor;
        this.identifierAssembler = identifierAssembler;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.entityInstance != null) {
            return;
        }
        this.identifier = this.identifierAssembler.assemble(rowProcessingState);
        if (this.identifier == null) {
            this.entityInstance = null;
        } else {
            EntityKey entityKey = new EntityKey(this.identifier, this.concreteDescriptor);
            PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContext();
            Object entity = persistenceContext.getEntity(entityKey);
            if (entity != null) {
                this.entityInstance = entity;
            } else {
                LoadingEntityEntry loadingEntityLocally = rowProcessingState.getJdbcValuesSourceProcessingState().findLoadingEntityLocally(entityKey);
                if (loadingEntityLocally != null) {
                    this.entityInstance = loadingEntityLocally.getEntityInstance();
                } else if (this.concreteDescriptor.hasProxy()) {
                    Object proxy = persistenceContext.getProxy(entityKey);
                    if (proxy != null) {
                        this.entityInstance = proxy;
                    } else {
                        this.entityInstance = this.concreteDescriptor.createProxy(this.identifier, rowProcessingState.getSession());
                        persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(entityKey);
                        persistenceContext.addProxy(entityKey, this.entityInstance);
                    }
                } else if (this.concreteDescriptor.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading()) {
                    this.entityInstance = this.concreteDescriptor.instantiate(this.identifier, rowProcessingState.getSession());
                }
            }
            this.notifyParentResolutionListeners(this.entityInstance);
        }
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.entityInstance = null;
        this.identifier = null;
        this.clearParentResolutionListeners();
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.concreteDescriptor;
    }

    @Override
    public Object getEntityInstance() {
        return this.entityInstance;
    }

    @Override
    public EntityKey getEntityKey() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public Object getParentKey() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public void registerResolutionListener(Consumer<Object> listener) {
        if (this.entityInstance != null) {
            listener.accept(this.entityInstance);
        } else {
            super.registerResolutionListener(listener);
        }
    }
}

