/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchTiming;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.AbstractNonLazyEntityFetch;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.graph.entity.internal.EntityJoinedFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntityResultImpl;

public class EntityFetchJoinedImpl
extends AbstractNonLazyEntityFetch {
    private final EntityResultImpl entityResult;
    private final LockMode lockMode;

    public EntityFetchJoinedImpl(FetchParent fetchParent, EntityValuedFetchable fetchedAttribute, LockMode lockMode, boolean nullable, NavigablePath navigablePath, DomainResultCreationState creationState) {
        super(fetchParent, fetchedAttribute, navigablePath, nullable);
        this.lockMode = lockMode;
        this.entityResult = new EntityResultImpl(navigablePath, fetchedAttribute, null, creationState);
    }

    @Override
    protected EntityInitializer getEntityInitializer(FetchParentAccess parentAccess, Consumer<Initializer> collector, AssemblerCreationState creationState) {
        return new EntityJoinedFetchInitializer(this.entityResult, this.getNavigablePath(), this.lockMode, this.entityResult.getIdentifierResult(), this.entityResult.getDiscriminatorResult(), this.entityResult.getVersionResult(), collector, creationState);
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public boolean hasTableGroup() {
        return true;
    }

    public EntityResultImpl getEntityResult() {
        return this.entityResult;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }
}

