/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.internal.SingularAssociationAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.internal.AbstractNonJoinedEntityFetch;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;

public class EntityFetchSelectImpl
extends AbstractNonJoinedEntityFetch {
    private final boolean nullable;
    private final DomainResult result;

    public EntityFetchSelectImpl(FetchParent fetchParent, SingularAssociationAttributeMapping fetchedAttribute, LockMode lockMode, boolean nullable, NavigablePath navigablePath, DomainResult result, DomainResultCreationState creationState) {
        super(navigablePath, fetchedAttribute, fetchParent);
        this.nullable = nullable;
        this.result = result;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public boolean hasTableGroup() {
        return false;
    }

    @Override
    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, Consumer<Initializer> collector, AssemblerCreationState creationState) {
        EntitySelectFetchInitializer initializer = new EntitySelectFetchInitializer(this.getNavigablePath(), this.getReferencedMappingContainer().getEntityPersister(), this.result.createResultAssembler(collector, creationState), this.nullable);
        collector.accept(initializer);
        return new EntityAssembler(this.getResultJavaTypeDescriptor(), initializer);
    }
}

