/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.metamodel.mapping.internal.SingularAssociationAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntityResultInitializer;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class RootEntityResultImpl
extends AbstractFetchParent
implements EntityResultGraphNode,
EntityResult {
    private final String resultVariable;
    private final EntityValuedModelPart referencedModelPart;
    private final DomainResult discriminatorResult;
    private final DomainResult versionResult;
    private final LockMode lockMode;

    public RootEntityResultImpl(NavigablePath navigablePath, EntityValuedModelPart entityValuedModelPart, String resultVariable, DomainResultCreationState creationState) {
        this(navigablePath, entityValuedModelPart, resultVariable, null, creationState);
    }

    public RootEntityResultImpl(NavigablePath navigablePath, EntityValuedModelPart entityValuedModelPart, String resultVariable, EntityMappingType targetType, DomainResultCreationState creationState) {
        super(entityValuedModelPart.getEntityMappingType(), navigablePath);
        this.resultVariable = resultVariable;
        this.referencedModelPart = entityValuedModelPart;
        this.lockMode = creationState.getSqlAstCreationState().determineLockMode(resultVariable);
        EntityMappingType entityDescriptor = this.referencedModelPart.getEntityMappingType();
        TableGroup entityTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(navigablePath);
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        if (identifierMapping instanceof SingleAttributeIdentifierMapping) {
            identifierMapping.createDomainResult(navigablePath.append("{id}"), entityTableGroup, null, creationState);
        } else {
            this.visitCompositeIdentifierMapping(navigablePath, creationState, identifierMapping, entityTableGroup);
        }
        EntityDiscriminatorMapping discriminatorMapping = this.getDiscriminatorMapping(entityDescriptor, entityTableGroup);
        this.discriminatorResult = discriminatorMapping != null ? discriminatorMapping.createDomainResult(navigablePath.append("{discriminator}"), entityTableGroup, null, creationState) : null;
        EntityVersionMapping versionDescriptor = entityDescriptor.getVersionMapping();
        this.versionResult = versionDescriptor == null ? null : versionDescriptor.createDomainResult(navigablePath.append(versionDescriptor.getFetchableName()), entityTableGroup, null, creationState);
        this.afterInitialize(creationState);
    }

    private void visitCompositeIdentifierMapping(NavigablePath navigablePath, DomainResultCreationState creationState, EntityIdentifierMapping identifierMapping, TableGroup entityTableGroup) {
        ManagedMappingType mappingType = (ManagedMappingType)identifierMapping.getPartMappingType();
        this.fetches = new ArrayList();
        mappingType.visitAttributeMappings(attributeMapping -> {
            if (attributeMapping instanceof SingularAssociationAttributeMapping) {
                ((SingularAssociationAttributeMapping)attributeMapping).getForeignKeyDescriptor().createDomainResult(navigablePath.append("{id}"), entityTableGroup, null, creationState);
            } else {
                attributeMapping.createDomainResult(navigablePath.append("{id}"), entityTableGroup, null, creationState);
            }
        });
    }

    protected EntityDiscriminatorMapping getDiscriminatorMapping(EntityMappingType entityDescriptor, TableGroup entityTableGroup) {
        return entityDescriptor.getDiscriminatorMapping();
    }

    @Override
    public EntityMappingType getReferencedMappingContainer() {
        return this.getEntityValuedModelPart().getEntityMappingType();
    }

    @Override
    public EntityValuedModelPart getEntityValuedModelPart() {
        return this.referencedModelPart;
    }

    @Override
    public JavaTypeDescriptor getResultJavaTypeDescriptor() {
        return this.getEntityValuedModelPart().getEntityMappingType().getMappedJavaTypeDescriptor();
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public DomainResult getDiscriminatorResult() {
        return this.discriminatorResult;
    }

    public DomainResult getVersionResult() {
        return this.versionResult;
    }

    @Override
    public FetchableContainer getReferencedMappingType() {
        return this.getReferencedMappingContainer();
    }

    @Override
    public EntityValuedModelPart getReferencedModePart() {
        return this.getEntityValuedModelPart();
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    public DomainResultAssembler createResultAssembler(Consumer initializerCollector, AssemblerCreationState creationState) {
        EntityResultInitializer initializer = new EntityResultInitializer((EntityResultGraphNode)this, this.getNavigablePath(), this.getLockMode(), null, this.getDiscriminatorResult(), this.getVersionResult(), (Consumer<Initializer>)initializerCollector, creationState);
        return new EntityAssembler(this.getResultJavaTypeDescriptor(), initializer);
    }

    public String toString() {
        return "EntityResultImpl {" + this.getNavigablePath() + "}";
    }
}

