/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.internal.StandardRowReader;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.sql.results.spi.RowTransformer;

public class Helper {
    public static <R> RowReader<R> createRowReader(SessionFactoryImplementor sessionFactory, Callback callback, RowTransformer<R> rowTransformer, JdbcValues jdbcValues) {
        ArrayList<Initializer> initializers = new ArrayList<Initializer>();
        List<DomainResultAssembler> assemblers = jdbcValues.getValuesMapping().resolveAssemblers(Helper.getInitializerConsumer(initializers), () -> sessionFactory);
        return new StandardRowReader<R>(assemblers, initializers, rowTransformer, callback);
    }

    private static Consumer<Initializer> getInitializerConsumer(List<Initializer> initializers) {
        if (ResultsLogger.INSTANCE.isDebugEnabled()) {
            return initializer -> {
                ResultsLogger.INSTANCE.debug("Adding initializer : " + initializer);
                Helper.addIfNotPresent(initializers, initializer);
            };
        }
        return initializer -> Helper.addIfNotPresent(initializers, initializer);
    }

    private static void addIfNotPresent(List<Initializer> initializers, Initializer initializer) {
        if (initializers.contains(initializer)) {
            return;
        }
        initializers.add(initializer);
    }

    public static void finalizeCollectionLoading(PersistenceContext persistenceContext, CollectionPersister collectionDescriptor, PersistentCollection collectionInstance, Object key) {
        CollectionEntry collectionEntry = persistenceContext.getCollectionEntry(collectionInstance);
        if (collectionEntry == null) {
            collectionEntry = persistenceContext.addInitializedCollection(collectionDescriptor, collectionInstance, key);
        } else {
            collectionEntry.postInitialize(collectionInstance);
        }
        if (collectionDescriptor.getCollectionType().hasHolder()) {
            persistenceContext.addCollectionHolder(collectionInstance);
        }
        BatchFetchQueue batchFetchQueue = persistenceContext.getBatchFetchQueue();
        batchFetchQueue.removeBatchLoadableCollection(collectionEntry);
    }
}

