/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.sql.SQLException;
import java.util.List;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.sql.results.spi.RowReader;
import org.jboss.logging.Logger;

public class RowProcessingStateStandardImpl
implements RowProcessingState {
    private static final Logger log = Logger.getLogger(RowProcessingStateStandardImpl.class);
    private static final Initializer[] NO_INITIALIZERS = new Initializer[0];
    private final JdbcValuesSourceProcessingStateStandardImpl resultSetProcessingState;
    private final QueryOptions queryOptions;
    private final Initializer[] initializers;
    private final JdbcValues jdbcValues;
    private Object[] currentRowJdbcValues;

    public RowProcessingStateStandardImpl(JdbcValuesSourceProcessingStateStandardImpl resultSetProcessingState, QueryOptions queryOptions, RowReader<?> rowReader, JdbcValues jdbcValues) {
        this.resultSetProcessingState = resultSetProcessingState;
        this.queryOptions = queryOptions;
        this.jdbcValues = jdbcValues;
        List<Initializer> initializers = rowReader.getInitializers();
        this.initializers = initializers == null || initializers.isEmpty() ? NO_INITIALIZERS : initializers.toArray(new Initializer[initializers.size()]);
    }

    @Override
    public JdbcValuesSourceProcessingState getJdbcValuesSourceProcessingState() {
        return this.resultSetProcessingState;
    }

    public boolean next() throws SQLException {
        if (this.jdbcValues.next(this)) {
            this.currentRowJdbcValues = this.jdbcValues.getCurrentRowValuesArray();
            return true;
        }
        this.currentRowJdbcValues = null;
        return false;
    }

    @Override
    public Object getJdbcValue(int position) {
        return this.currentRowJdbcValues[position];
    }

    @Override
    public void registerNonExists(EntityFetch fetch) {
    }

    @Override
    public void finishRowProcessing() {
        this.currentRowJdbcValues = null;
    }

    @Override
    public SharedSessionContractImplementor getSession() {
        return this.getJdbcValuesSourceProcessingState().getExecutionContext().getSession();
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.getJdbcValuesSourceProcessingState().getExecutionContext().getQueryParameterBindings();
    }

    @Override
    public Callback getCallback() {
        return afterLoadAction -> {};
    }

    @Override
    public Initializer resolveInitializer(NavigablePath path) {
        for (Initializer initializer : this.initializers) {
            if (!initializer.getNavigablePath().equals(path)) continue;
            return initializer;
        }
        return null;
    }
}

