/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.named.RowReaderMemento;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.sql.results.spi.RowTransformer;
import org.jboss.logging.Logger;

public class StandardRowReader<T>
implements RowReader<T> {
    private static final Logger LOG = Logger.getLogger(StandardRowReader.class);
    private final List<DomainResultAssembler> resultAssemblers;
    private final List<Initializer> initializers;
    private final RowTransformer<T> rowTransformer;
    private final int assemblerCount;
    private final Callback callback;
    private final Object[] resultRow;

    public StandardRowReader(List<DomainResultAssembler> resultAssemblers, List<Initializer> initializers, RowTransformer<T> rowTransformer, Callback callback) {
        this.resultAssemblers = resultAssemblers;
        this.initializers = initializers;
        this.rowTransformer = rowTransformer;
        this.assemblerCount = resultAssemblers.size();
        this.callback = callback;
        this.resultRow = new Object[this.assemblerCount];
    }

    @Override
    public Class<T> getResultJavaType() {
        if (this.resultAssemblers.size() == 1) {
            return this.resultAssemblers.get(0).getAssembledJavaTypeDescriptor().getJavaType();
        }
        return Object[].class;
    }

    @Override
    public List<Initializer> getInitializers() {
        return this.initializers;
    }

    @Override
    public T readRow(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        LOG.debug((Object)"---Processing Row---");
        this.coordinateInitializers(rowProcessingState, options);
        for (int i = 0; i < this.assemblerCount; ++i) {
            this.resultRow[i] = this.resultAssemblers.get(i).assemble(rowProcessingState, options);
        }
        this.afterRow(rowProcessingState, options);
        return this.rowTransformer.transformRow(this.resultRow);
    }

    private void afterRow(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        for (Initializer initializer : this.initializers) {
            initializer.finishUpRow(rowProcessingState);
        }
    }

    private void coordinateInitializers(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        Initializer initializer;
        int i;
        for (i = 0; i < this.initializers.size(); ++i) {
            initializer = this.initializers.get(i);
            if (initializer instanceof CollectionInitializer) continue;
            initializer.resolveKey(rowProcessingState);
        }
        for (i = 0; i < this.initializers.size(); ++i) {
            initializer = this.initializers.get(i);
            if (!(initializer instanceof CollectionInitializer)) continue;
            initializer.resolveKey(rowProcessingState);
        }
        for (i = 0; i < this.initializers.size(); ++i) {
            this.initializers.get(i).resolveInstance(rowProcessingState);
        }
        for (i = 0; i < this.initializers.size(); ++i) {
            this.initializers.get(i).initializeInstance(rowProcessingState);
        }
    }

    @Override
    public void finishUp(JdbcValuesSourceProcessingState processingState) {
        for (int i = 0; i < this.initializers.size(); ++i) {
            this.initializers.get(i).endLoading(processingState.getExecutionContext());
        }
    }

    @Override
    public RowReaderMemento toMemento(SessionFactoryImplementor factory) {
        return new RowReaderMemento(){

            @Override
            public Class[] getResultClasses() {
                return new Class[0];
            }

            @Override
            public String[] getResultMappingNames() {
                return new String[0];
            }
        };
    }
}

