/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.List;
import javax.persistence.TupleElement;
import org.hibernate.query.JpaTuple;

public class TupleImpl
implements JpaTuple {
    private final List<TupleElement<?>> tupleElements;
    private final Object[] row;

    public TupleImpl(List<TupleElement<?>> tupleElements, Object[] row) {
        this.tupleElements = tupleElements;
        this.row = row;
    }

    public <X> X get(TupleElement<X> tupleElement) {
        int index = this.tupleElements.indexOf(tupleElement);
        if (index < 0) {
            throw new IllegalArgumentException("Requested tuple element did not correspond to element in the result tuple");
        }
        return (X)this.row[index];
    }

    public <X> X get(String alias, Class<X> type) {
        Object untyped = this.get(alias);
        if (untyped != null && !type.isInstance(untyped)) {
            throw new IllegalArgumentException(String.format("Requested tuple value [alias=%s, value=%s] cannot be assigned to requested type [%s]", alias, untyped, type.getName()));
        }
        return (X)untyped;
    }

    public Object get(String alias) {
        int index = -1;
        if (alias != null && (alias = alias.trim()).length() > 0) {
            int i = 0;
            for (TupleElement<?> selection : this.tupleElements) {
                if (alias.equals(selection.getAlias())) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index < 0) {
            throw new IllegalArgumentException("Given alias [" + alias + "] did not correspond to an element in the result tuple");
        }
        return this.row[index];
    }

    public <X> X get(int i, Class<X> type) {
        Object result = this.get(i);
        if (result != null && !type.isInstance(result)) {
            throw new IllegalArgumentException(String.format("Requested tuple value [index=%s, realType=%s] cannot be assigned to requested type [%s]", i, result.getClass().getName(), type.getName()));
        }
        return (X)result;
    }

    public Object get(int i) {
        if (i >= this.row.length) {
            throw new IllegalArgumentException("Given index [" + i + "] was outside the range of result tuple size [" + this.row.length + "] ");
        }
        return this.row[i];
    }

    public Object[] toArray() {
        return this.row;
    }

    public List<TupleElement<?>> getElements() {
        return this.tupleElements;
    }
}

