/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.sql.SQLException;
import org.hibernate.sql.results.caching.QueryCachePutManager;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractJdbcValues
implements JdbcValues {
    private final QueryCachePutManager queryCachePutManager;

    public AbstractJdbcValues(QueryCachePutManager queryCachePutManager) {
        if (queryCachePutManager == null) {
            throw new IllegalArgumentException("QueryCachePutManager cannot be null");
        }
        this.queryCachePutManager = queryCachePutManager;
    }

    @Override
    public final boolean next(RowProcessingState rowProcessingState) throws SQLException {
        if (this.getCurrentRowValuesArray() != null) {
            this.queryCachePutManager.registerJdbcRow(this.getCurrentRowValuesArray());
        }
        return this.processNext(rowProcessingState);
    }

    protected abstract boolean processNext(RowProcessingState var1);

    @Override
    public final void finishUp() {
        this.queryCachePutManager.finishUp();
        this.release();
    }

    protected abstract void release();
}

