/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.sql.SQLException;
import org.hibernate.CacheMode;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.query.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.exec.ExecutionException;
import org.hibernate.sql.exec.internal.JdbcExecHelper;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.caching.QueryCachePutManager;
import org.hibernate.sql.results.caching.internal.QueryCachePutManagerDisabledImpl;
import org.hibernate.sql.results.caching.internal.QueryCachePutManagerEnabledImpl;
import org.hibernate.sql.results.jdbc.internal.AbstractJdbcValues;
import org.hibernate.sql.results.jdbc.internal.ResultSetAccess;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.WrapperOptions;

public class JdbcValuesResultSetImpl
extends AbstractJdbcValues {
    private final ResultSetAccess resultSetAccess;
    private final JdbcValuesMapping valuesMapping;
    private final ExecutionContext executionContext;
    private final SqlSelection[] sqlSelections;
    private final Object[] currentRowJdbcValues;
    private final int numberOfRowsToProcess;
    private int position = -1;

    public JdbcValuesResultSetImpl(ResultSetAccess resultSetAccess, QueryKey queryCacheKey, QueryOptions queryOptions, JdbcValuesMapping valuesMapping, ExecutionContext executionContext) {
        super(JdbcValuesResultSetImpl.resolveQueryCachePutManager(executionContext, queryOptions, queryCacheKey));
        this.resultSetAccess = resultSetAccess;
        this.valuesMapping = valuesMapping;
        this.executionContext = executionContext;
        this.numberOfRowsToProcess = JdbcValuesResultSetImpl.interpretNumberOfRowsToProcess(queryOptions);
        this.sqlSelections = valuesMapping.getSqlSelections().toArray(new SqlSelection[0]);
        this.currentRowJdbcValues = new Object[this.sqlSelections.length];
    }

    private static int interpretNumberOfRowsToProcess(QueryOptions queryOptions) {
        if (queryOptions == null || queryOptions.getLimit() == null) {
            return -1;
        }
        Limit limit = queryOptions.getLimit();
        if (limit.getMaxRows() == null) {
            return -1;
        }
        return limit.getMaxRows();
    }

    private static QueryCachePutManager resolveQueryCachePutManager(ExecutionContext executionContext, QueryOptions queryOptions, QueryKey queryCacheKey) {
        boolean queryCacheEnabled = executionContext.getSession().getFactory().getSessionFactoryOptions().isQueryCacheEnabled();
        CacheMode cacheMode = JdbcExecHelper.resolveCacheMode(executionContext);
        if (queryCacheEnabled && cacheMode.isPutEnabled()) {
            QueryResultsCache queryCache = executionContext.getSession().getFactory().getCache().getQueryResultsCache(queryOptions.getResultCacheRegionName());
            return new QueryCachePutManagerEnabledImpl(queryCache, queryCacheKey);
        }
        return QueryCachePutManagerDisabledImpl.INSTANCE;
    }

    @Override
    protected final boolean processNext(RowProcessingState rowProcessingState) {
        if (this.numberOfRowsToProcess != -1 && this.position > this.numberOfRowsToProcess) {
            return false;
        }
        ++this.position;
        try {
            if (!this.resultSetAccess.getResultSet().next()) {
                return false;
            }
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error advancing JDBC ResultSet", e);
        }
        try {
            this.readCurrentRowValues(rowProcessingState);
            return true;
        }
        catch (SQLException e) {
            throw this.makeExecutionException("Error reading JDBC row values", e);
        }
    }

    private ExecutionException makeExecutionException(String message, SQLException cause) {
        return new ExecutionException(message, (Throwable)((Object)this.executionContext.getSession().getJdbcServices().getSqlExceptionHelper().convert(cause, message)));
    }

    private void readCurrentRowValues(RowProcessingState rowProcessingState) throws SQLException {
        for (SqlSelection sqlSelection : this.sqlSelections) {
            this.currentRowJdbcValues[sqlSelection.getValuesArrayPosition()] = sqlSelection.getJdbcValueExtractor().extract(this.resultSetAccess.getResultSet(), sqlSelection.getJdbcResultSetIndex(), (WrapperOptions)this.executionContext.getSession());
        }
    }

    @Override
    protected void release() {
        this.resultSetAccess.release();
    }

    @Override
    public JdbcValuesMapping getValuesMapping() {
        return this.valuesMapping;
    }

    @Override
    public Object[] getCurrentRowValuesArray() {
        return this.currentRowJdbcValues;
    }
}

