/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.sql.results.graph.collection.internal.ArrayInitializer;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.jboss.logging.Logger;

public class JdbcValuesSourceProcessingStateStandardImpl
implements JdbcValuesSourceProcessingState {
    private static final Logger log = Logger.getLogger(JdbcValuesSourceProcessingStateStandardImpl.class);
    private final ExecutionContext executionContext;
    private final JdbcValuesSourceProcessingOptions processingOptions;
    private final BiConsumer<EntityKey, LoadingEntityEntry> loadingEntityEntryConsumer;
    private Map<EntityKey, LoadingEntityEntry> loadingEntityMap;
    private Map<CollectionKey, LoadingCollectionEntry> loadingCollectionMap;
    private List<CollectionInitializer> arrayInitializers;
    private final PreLoadEvent preLoadEvent;
    private final PostLoadEvent postLoadEvent;

    public JdbcValuesSourceProcessingStateStandardImpl(ExecutionContext executionContext, JdbcValuesSourceProcessingOptions processingOptions, BiConsumer<EntityKey, LoadingEntityEntry> loadingEntityEntryListener) {
        this.executionContext = executionContext;
        this.processingOptions = processingOptions;
        this.loadingEntityEntryConsumer = loadingEntityEntryListener;
        if (executionContext.getSession() instanceof EventSource) {
            this.preLoadEvent = new PreLoadEvent((EventSource)executionContext.getSession());
            this.postLoadEvent = new PostLoadEvent((EventSource)executionContext.getSession());
        } else {
            this.preLoadEvent = null;
            this.postLoadEvent = null;
        }
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.executionContext.getQueryOptions();
    }

    @Override
    public JdbcValuesSourceProcessingOptions getProcessingOptions() {
        return this.processingOptions;
    }

    @Override
    public PreLoadEvent getPreLoadEvent() {
        return this.preLoadEvent;
    }

    @Override
    public PostLoadEvent getPostLoadEvent() {
        return this.postLoadEvent;
    }

    @Override
    public void registerLoadingEntity(EntityKey entityKey, LoadingEntityEntry loadingEntry) {
        if (this.loadingEntityMap == null) {
            this.loadingEntityMap = new HashMap<EntityKey, LoadingEntityEntry>();
        }
        if (this.loadingEntityEntryConsumer != null) {
            this.loadingEntityEntryConsumer.accept(entityKey, loadingEntry);
        }
        this.loadingEntityMap.put(entityKey, loadingEntry);
    }

    @Override
    public LoadingEntityEntry findLoadingEntityLocally(EntityKey entityKey) {
        return this.loadingEntityMap == null ? null : this.loadingEntityMap.get(entityKey);
    }

    @Override
    public LoadingCollectionEntry findLoadingCollectionLocally(CollectionKey key) {
        if (this.loadingCollectionMap == null) {
            return null;
        }
        return this.loadingCollectionMap.get(key);
    }

    @Override
    public void registerLoadingCollection(CollectionKey key, LoadingCollectionEntry loadingCollectionEntry) {
        if (this.loadingCollectionMap == null) {
            this.loadingCollectionMap = new HashMap<CollectionKey, LoadingCollectionEntry>();
        }
        this.loadingCollectionMap.put(key, loadingCollectionEntry);
        if (loadingCollectionEntry.getInitializer() instanceof ArrayInitializer) {
            if (this.arrayInitializers == null) {
                this.arrayInitializers = new ArrayList<CollectionInitializer>();
            }
            this.arrayInitializers.add(loadingCollectionEntry.getInitializer());
        }
    }

    @Override
    public SharedSessionContractImplementor getSession() {
        return this.executionContext.getSession();
    }

    @Override
    public void finishUp() {
        try {
            this.finishLoadingArrays();
            this.performTwoPhaseLoad();
            this.finishLoadingCollections();
        }
        finally {
            this.executionContext.getSession().getPersistenceContext().getLoadContexts().deregister(this);
        }
    }

    private void finishLoadingArrays() {
        if (this.arrayInitializers != null) {
            for (CollectionInitializer collectionInitializer : this.arrayInitializers) {
                collectionInitializer.endLoading(this.executionContext);
            }
        }
    }

    private void performTwoPhaseLoad() {
        if (this.loadingEntityMap == null) {
            return;
        }
        log.tracev("Total objects hydrated: {0}", (Object)this.loadingEntityMap.size());
    }

    private boolean isReadOnly() {
        if (this.getQueryOptions().isReadOnly() != null) {
            return this.getQueryOptions().isReadOnly();
        }
        if (this.executionContext.getSession() instanceof EventSource) {
            return this.executionContext.getSession().isDefaultReadOnly();
        }
        return false;
    }

    private void finishLoadingCollections() {
        if (this.loadingCollectionMap != null) {
            for (LoadingCollectionEntry loadingCollectionEntry : this.loadingCollectionMap.values()) {
                loadingCollectionEntry.finishLoading(this.getExecutionContext());
            }
            this.loadingCollectionMap.clear();
        }
    }
}

