/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.script;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.hibernate.dialect.Dialect;
import org.hibernate.grammars.importsql.SqlScriptLexer;
import org.hibernate.grammars.importsql.SqlScriptParser;
import org.hibernate.tool.schema.internal.script.SqlScriptVisitor;
import org.hibernate.tool.schema.spi.SqlScriptCommandExtractor;
import org.hibernate.tool.schema.spi.SqlScriptException;

public class MultiLineSqlScriptExtracter
implements SqlScriptCommandExtractor {
    public static final String SHORT_NAME = "multi-line";
    public static final MultiLineSqlScriptExtracter INSTANCE = new MultiLineSqlScriptExtracter();

    @Override
    public List<String> extractCommands(Reader reader, Dialect dialect) {
        try {
            SqlScriptParser.ScriptContext scriptParseTree = MultiLineSqlScriptExtracter.buildScriptParseTree(reader);
            SqlScriptVisitor visitor = new SqlScriptVisitor(dialect);
            return visitor.visitScript(scriptParseTree);
        }
        catch (Exception e) {
            throw new SqlScriptException("Error during sql-script parsing.", e);
        }
    }

    private static SqlScriptParser.ScriptContext buildScriptParseTree(Reader reader) throws IOException {
        SqlScriptLexer lexer = new SqlScriptLexer((CharStream)CharStreams.fromReader((Reader)reader));
        return MultiLineSqlScriptExtracter.buildScriptParseTree(lexer);
    }

    private static SqlScriptParser.ScriptContext buildScriptParseTree(SqlScriptLexer lexer) {
        return MultiLineSqlScriptExtracter.buildScriptParseTree(lexer, new SqlScriptParser((TokenStream)new CommonTokenStream((TokenSource)lexer)));
    }

    private static SqlScriptParser.ScriptContext buildScriptParseTree(SqlScriptLexer lexer, SqlScriptParser parser) {
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.removeErrorListeners();
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        try {
            return parser.script();
        }
        catch (ParseCancellationException e) {
            lexer.reset();
            parser.reset();
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            parser.addErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
            parser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy());
            return parser.script();
        }
    }
}

