/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.Instantiator;

public class DynamicMapInstantiator
implements Instantiator {
    public static final String KEY = "$type$";
    private final String roleName;
    private Set<String> isInstanceEntityNames = new HashSet<String>();

    public DynamicMapInstantiator() {
        this.roleName = null;
    }

    public DynamicMapInstantiator(PersistentClass mappingInfo) {
        this.roleName = mappingInfo.getEntityName();
        this.isInstanceEntityNames.add(this.roleName);
        if (mappingInfo.hasSubclasses()) {
            Iterator itr = mappingInfo.getSubclassClosureIterator();
            while (itr.hasNext()) {
                PersistentClass subclassInfo = (PersistentClass)itr.next();
                this.isInstanceEntityNames.add(subclassInfo.getEntityName());
            }
        }
    }

    @Override
    public final Object instantiate(Serializable id) {
        return this.instantiate();
    }

    @Override
    public final Object instantiate() {
        Map map = this.generateMap();
        if (this.roleName != null) {
            map.put(KEY, this.roleName);
        }
        return map;
    }

    @Override
    public final boolean isInstance(Object object) {
        if (object instanceof Map) {
            if (this.roleName == null) {
                return true;
            }
            String type = (String)((Map)object).get(KEY);
            return type == null || this.isInstanceEntityNames.contains(type);
        }
        return false;
    }

    protected Map generateMap() {
        return new HashMap();
    }
}

