/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.internal.StandardBasicTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.UserType;

public class BasicTypeRegistry
implements Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(BasicTypeRegistry.class);
    private final TypeConfiguration typeConfiguration;
    private final Map<SqlTypeDescriptor, Map<JavaTypeDescriptor<?>, BasicType<?>>> registryValues = new ConcurrentHashMap();
    private boolean primed;
    private Map<String, BasicType> typesByName = new ConcurrentHashMap<String, BasicType>();

    public BasicTypeRegistry(TypeConfiguration typeConfiguration) {
        this.typeConfiguration = typeConfiguration;
    }

    public BasicType getRegisteredType(String key) {
        return this.typesByName.get(key);
    }

    public BasicType getRegisteredType(Class javaType) {
        return this.getRegisteredType(javaType.getName());
    }

    public BasicType<?> resolve(JavaTypeDescriptor<?> jtdToUse, SqlTypeDescriptor stdToUse) {
        return this.resolve(jtdToUse, stdToUse, () -> new StandardBasicTypeImpl(jtdToUse, stdToUse));
    }

    public BasicType<?> resolve(JavaTypeDescriptor<?> jtdToUse, SqlTypeDescriptor stdToUse, Supplier<BasicType<?>> creator) {
        Map typeByJtdForStd = this.registryValues.computeIfAbsent(stdToUse, sqlTypeDescriptor -> new ConcurrentHashMap());
        return typeByJtdForStd.computeIfAbsent(jtdToUse, javaDescriptor -> (BasicType)creator.get());
    }

    public void register(BasicType type) {
        this.register(type, type.getRegistrationKeys());
    }

    public void register(BasicType type, String key) {
        this.typesByName.put(key, type);
    }

    public void register(BasicType type, String ... keys) {
        if (!this.isPrimed()) {
            throw new IllegalStateException("BasicTypeRegistry not yet primed.  Calls to `#register` not valid until after primed");
        }
        if (type == null) {
            throw new HibernateException("Type to register cannot be null");
        }
        this.applyOrOverwriteEntry(type);
        if (CollectionHelper.isEmpty(keys)) {
            LOG.typeDefinedNoRegistrationKeys(type);
        } else {
            this.applyRegistrationKeys(type, keys);
        }
    }

    private void applyOrOverwriteEntry(BasicType type) {
        Map mappingsForStdToUse = this.registryValues.computeIfAbsent(type.getSqlTypeDescriptor(), sqlTypeDescriptor -> new ConcurrentHashMap());
        BasicType existing = mappingsForStdToUse.put(type.getMappedJavaTypeDescriptor(), type);
        if (existing != null) {
            LOG.debugf("BasicTypeRegistry registration overwritten (%s + %s); previous =`%s`", type.getSqlTypeDescriptor().getFriendlyName(), type.getJavaTypeDescriptor(), existing);
        }
    }

    public void register(UserType type, String ... keys) {
        this.register(new CustomType(type, keys, this.typeConfiguration));
    }

    public void unregister(String ... keys) {
        for (String key : keys) {
            BasicType basicType = this.typesByName.remove(key);
        }
    }

    public boolean isPrimed() {
        return this.primed;
    }

    public void primed() {
        this.primed = true;
    }

    public void addPrimeEntry(BasicType type, String legacyTypeClassName, String[] registrationKeys) {
        if (this.primed) {
            throw new IllegalStateException("BasicTypeRegistry already primed");
        }
        if (type == null) {
            throw new HibernateException("Type to register cannot be null");
        }
        this.primeRegistryEntry(type);
        if (StringHelper.isNotEmpty(legacyTypeClassName)) {
            this.typesByName.put(legacyTypeClassName, type);
        }
        if (registrationKeys == null || registrationKeys.length == 0) {
            LOG.typeDefinedNoRegistrationKeys(type);
        } else {
            this.applyRegistrationKeys(type, registrationKeys);
        }
    }

    private void primeRegistryEntry(BasicType type) {
        Map mappingsForStdToUse = this.registryValues.computeIfAbsent(type.getSqlTypeDescriptor(), sqlTypeDescriptor -> new ConcurrentHashMap());
        BasicType existing = (BasicType)mappingsForStdToUse.get(type.getMappedJavaTypeDescriptor());
        if (existing != null) {
            LOG.debugf("Skipping registration of BasicType (%s + %s); still priming.  existing = %s", type.getSqlTypeDescriptor().getFriendlyName(), type.getJavaTypeDescriptor(), existing);
        } else {
            mappingsForStdToUse.put(type.getMappedJavaTypeDescriptor(), type);
        }
    }

    private void applyRegistrationKeys(BasicType type, String[] keys) {
        for (String key : keys) {
            if (key == null) continue;
            key = key.intern();
            LOG.debugf("Adding type registration %s -> %s", key, type);
            Type old = this.typesByName.put(key, type);
            if (old == null || old == type) continue;
            LOG.debugf("Type registration key [%s] overrode previous entry : `%s`", key, old);
        }
    }
}

