/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CharacterArrayClobType;
import org.hibernate.type.CharacterArrayNClobType;
import org.hibernate.type.SqlTypeDescriptorIndicatorCapable;
import org.hibernate.type.descriptor.java.PrimitiveCharacterArrayTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.VarcharTypeDescriptor;

public class CharArrayType
extends AbstractSingleColumnStandardBasicType<char[]>
implements SqlTypeDescriptorIndicatorCapable<char[]> {
    public static final CharArrayType INSTANCE = new CharArrayType();

    public CharArrayType() {
        super(VarcharTypeDescriptor.INSTANCE, PrimitiveCharacterArrayTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "characters";
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{this.getName(), "char[]", char[].class.getName()};
    }

    @Override
    public <X> BasicType<X> resolveIndicatedType(SqlTypeDescriptorIndicators indicators) {
        if (indicators.isLob()) {
            return indicators.isNationalized() ? CharacterArrayNClobType.INSTANCE : CharacterArrayClobType.INSTANCE;
        }
        if (indicators.isNationalized()) {
            SqlTypeDescriptor nvarcharType = indicators.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(-9);
            return indicators.getTypeConfiguration().getBasicTypeRegistry().resolve(this.getJavaTypeDescriptor(), nvarcharType);
        }
        return this;
    }
}

