/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.type.AbstractType;
import org.hibernate.type.BasicType;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.IdentifierType;
import org.hibernate.type.ProcedureParameterExtractionAware;
import org.hibernate.type.ProcedureParameterNamedBinder;
import org.hibernate.type.StringRepresentableType;
import org.hibernate.type.VersionType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.LoggableUserType;
import org.hibernate.usertype.Sized;
import org.hibernate.usertype.UserType;
import org.hibernate.usertype.UserVersionType;

public class CustomType
extends AbstractType
implements BasicType,
IdentifierType,
DiscriminatorType,
VersionType,
StringRepresentableType,
ProcedureParameterNamedBinder,
ProcedureParameterExtractionAware {
    private final UserType userType;
    private final String[] registrationKeys;
    private final String name;
    private final JavaTypeDescriptor mappedJavaTypeDescriptor;
    private final SqlTypeDescriptor sqlTypeDescriptor;
    private final Size dictatedSize;
    private final Size defaultSize;
    private final boolean customLogging;

    public CustomType(UserType userType, TypeConfiguration typeConfiguration) throws MappingException {
        this(userType, ArrayHelper.EMPTY_STRING_ARRAY, typeConfiguration);
    }

    public CustomType(UserType userType, String[] registrationKeys, TypeConfiguration typeConfiguration) throws MappingException {
        this.userType = userType;
        this.name = userType.getClass().getName();
        this.mappedJavaTypeDescriptor = typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(userType.returnedClass());
        this.sqlTypeDescriptor = typeConfiguration.getSqlTypeDescriptorRegistry().getDescriptor(userType.sqlTypes()[0]);
        if (userType instanceof Sized) {
            Sized sized = (Sized)((Object)userType);
            this.dictatedSize = sized.dictatedSizes()[0];
            this.defaultSize = sized.defaultSizes()[0];
        } else {
            this.dictatedSize = null;
            this.defaultSize = null;
        }
        this.customLogging = userType instanceof LoggableUserType;
        this.registrationKeys = registrationKeys;
    }

    public UserType getUserType() {
        return this.userType;
    }

    @Override
    public SqlTypeDescriptor getSqlTypeDescriptor() {
        return this.sqlTypeDescriptor;
    }

    @Override
    public int[] sqlTypes(Mapping pi) {
        return new int[]{this.sqlTypeDescriptor.getSqlType()};
    }

    @Override
    public String[] getRegistrationKeys() {
        return this.registrationKeys;
    }

    @Override
    public Size[] dictatedSizes(Mapping mapping) throws MappingException {
        return new Size[]{this.dictatedSize};
    }

    @Override
    public Size[] defaultSizes(Mapping mapping) throws MappingException {
        return new Size[]{this.defaultSize};
    }

    @Override
    public int getColumnSpan(Mapping session) {
        return 1;
    }

    @Override
    public Class getReturnedClass() {
        return this.getUserType().returnedClass();
    }

    @Override
    public boolean isEqual(Object x, Object y) throws HibernateException {
        return this.getUserType().equals(x, y);
    }

    @Override
    public int getHashCode(Object x) {
        return this.getUserType().hashCode(x);
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws SQLException {
        return this.getUserType().nullSafeGet(rs, names, session, owner);
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String columnName, SharedSessionContractImplementor session, Object owner) throws SQLException {
        return this.nullSafeGet(rs, new String[]{columnName}, session, owner);
    }

    @Override
    public Object assemble(Serializable cached, SharedSessionContractImplementor session, Object owner) {
        return this.getUserType().assemble(cached, owner);
    }

    @Override
    public Serializable disassemble(Object value, SharedSessionContractImplementor session, Object owner) {
        return this.getUserType().disassemble(value);
    }

    @Override
    public Object replace(Object original, Object target, SharedSessionContractImplementor session, Object owner, Map copyCache) throws HibernateException {
        return this.getUserType().replace(original, target, owner);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SharedSessionContractImplementor session) throws SQLException {
        if (settable[0]) {
            this.getUserType().nullSafeSet(st, value, index, session);
        }
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws SQLException {
        this.getUserType().nullSafeSet(st, value, index, session);
    }

    public String toXMLString(Object value, SessionFactoryImplementor factory) {
        return this.toString(value);
    }

    public Object fromXMLString(String xml, Mapping factory) {
        return this.fromStringValue(xml);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object deepCopy(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return this.getUserType().deepCopy(value);
    }

    @Override
    public boolean isMutable() {
        return this.getUserType().isMutable();
    }

    @Override
    public Object stringToObject(String xml) {
        return this.fromStringValue(xml);
    }

    @Override
    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return ((EnhancedUserType)this.getUserType()).objectToSQLString(value);
    }

    public Comparator getComparator() {
        return (Comparator)((Object)this.getUserType());
    }

    public Object next(Object current, SharedSessionContractImplementor session) {
        return ((UserVersionType)this.getUserType()).next(current, session);
    }

    public Object seed(SharedSessionContractImplementor session) {
        return ((UserVersionType)this.getUserType()).seed(session);
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (value == null) {
            return "null";
        }
        if (this.customLogging) {
            return ((LoggableUserType)((Object)this.getUserType())).toLoggableString(value, factory);
        }
        return this.toXMLString(value, factory);
    }

    @Override
    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        boolean[] result = new boolean[this.getColumnSpan(mapping)];
        if (value != null) {
            Arrays.fill(result, true);
        }
        return result;
    }

    @Override
    public boolean isDirty(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) throws HibernateException {
        return checkable[0] && this.isDirty(old, current, session);
    }

    public String toString(Object value) throws HibernateException {
        if (this.getUserType() instanceof StringRepresentableType) {
            return ((StringRepresentableType)((Object)this.getUserType())).toString(value);
        }
        if (value == null) {
            return null;
        }
        if (this.getUserType() instanceof EnhancedUserType) {
            return ((EnhancedUserType)this.getUserType()).toXMLString(value);
        }
        return value.toString();
    }

    public Object fromStringValue(String string) throws HibernateException {
        if (this.getUserType() instanceof StringRepresentableType) {
            return ((StringRepresentableType)((Object)this.getUserType())).fromStringValue(string);
        }
        if (this.getUserType() instanceof EnhancedUserType) {
            return ((EnhancedUserType)this.getUserType()).fromXMLString(string);
        }
        throw new HibernateException(String.format("Could not process #fromStringValue, UserType class [%s] did not implement %s or %s", this.name, StringRepresentableType.class.getName(), EnhancedUserType.class.getName()));
    }

    @Override
    public boolean canDoSetting() {
        if (this.getUserType() instanceof ProcedureParameterNamedBinder) {
            return ((ProcedureParameterNamedBinder)((Object)this.getUserType())).canDoSetting();
        }
        return false;
    }

    @Override
    public void nullSafeSet(CallableStatement statement, Object value, String name, SharedSessionContractImplementor session) throws SQLException {
        if (!this.canDoSetting()) {
            throw new UnsupportedOperationException("Type [" + this.getUserType() + "] does support parameter binding by name");
        }
        ((ProcedureParameterNamedBinder)((Object)this.getUserType())).nullSafeSet(statement, value, name, session);
    }

    @Override
    public boolean canDoExtraction() {
        if (this.getUserType() instanceof ProcedureParameterExtractionAware) {
            return ((ProcedureParameterExtractionAware)((Object)this.getUserType())).canDoExtraction();
        }
        return false;
    }

    @Override
    public Object extract(CallableStatement statement, int startIndex, SharedSessionContractImplementor session) throws SQLException {
        if (this.canDoExtraction()) {
            return ((ProcedureParameterExtractionAware)((Object)this.getUserType())).extract(statement, startIndex, session);
        }
        throw new UnsupportedOperationException("Type [" + this.getUserType() + "] does support parameter value extraction");
    }

    @Override
    public Object extract(CallableStatement statement, String paramName, SharedSessionContractImplementor session) throws SQLException {
        if (this.canDoExtraction()) {
            return ((ProcedureParameterExtractionAware)((Object)this.getUserType())).extract(statement, paramName, session);
        }
        throw new UnsupportedOperationException("Type [" + this.getUserType() + "] does support parameter value extraction");
    }

    public int hashCode() {
        return this.getUserType().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CustomType && this.getUserType().equals(((CustomType)obj).getUserType());
    }

    public Class getJavaType() {
        return this.mappedJavaTypeDescriptor.getJavaType();
    }

    @Override
    public JavaTypeDescriptor getMappedJavaTypeDescriptor() {
        return this.mappedJavaTypeDescriptor;
    }

    @Override
    public JavaTypeDescriptor getExpressableJavaTypeDescriptor() {
        return this.getMappedJavaTypeDescriptor();
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.getMappedJavaTypeDescriptor();
    }
}

