/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor;

import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DateTimeUtils {
    public static final String FORMAT_STRING_DATE = "yyyy-MM-dd";
    public static final String FORMAT_STRING_TIME_WITH_OFFSET = "HH:mm:ssxxx";
    public static final String FORMAT_STRING_TIME = "HH:mm:ss";
    public static final String FORMAT_STRING_TIMESTAMP = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_STRING_TIMESTAMP_WITH_MILLIS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FORMAT_STRING_TIMESTAMP_WITH_MICROS = "yyyy-MM-dd HH:mm:ss.SSSSSS";
    public static final String FORMAT_STRING_TIMESTAMP_WITH_OFFSET = "yyyy-MM-dd HH:mm:ss.SSSSSSxxx";
    public static final DateTimeFormatter DATE_TIME_FORMATTER_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIME_WITH_OFFSET = DateTimeFormatter.ofPattern("HH:mm:ssxxx", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIME = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIMESTAMP_WITH_MILLIS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIMESTAMP_WITH_MICROS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIMESTAMP_WITH_OFFSET = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSxxx", Locale.ENGLISH);
    public static final String JDBC_ESCAPE_START_DATE = "{d '";
    public static final String JDBC_ESCAPE_START_TIME = "{t '";
    public static final String JDBC_ESCAPE_START_TIMESTAMP = "{ts '";
    public static final String JDBC_ESCAPE_END = "'}";
    public static final DateTimeFormatter DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendLiteral('T').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendZoneOrOffsetId().optionalEnd().toFormatter();
    public static final DateTimeFormatter OFFSET_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendLiteral('T').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendLiteral(' ').optionalEnd().appendOffset("+HH:mm", "+00").toFormatter();

    private DateTimeUtils() {
    }

    public static String formatAsTimestampWithMicros(TemporalAccessor temporalAccessor) {
        return temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS) ? DATE_TIME_FORMATTER_TIMESTAMP_WITH_OFFSET.format(temporalAccessor) : DATE_TIME_FORMATTER_TIMESTAMP_WITH_MICROS.format(temporalAccessor);
    }

    public static String formatAsTimestampWithMillis(TemporalAccessor temporalAccessor) {
        return DATE_TIME_FORMATTER_TIMESTAMP_WITH_MILLIS.format(temporalAccessor);
    }

    public static String formatAsDate(TemporalAccessor temporalAccessor) {
        return DATE_TIME_FORMATTER_DATE.format(temporalAccessor);
    }

    public static String formatAsTime(TemporalAccessor temporalAccessor) {
        if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            return DATE_TIME_FORMATTER_TIME_WITH_OFFSET.format(temporalAccessor);
        }
        return DATE_TIME_FORMATTER_TIME.format(temporalAccessor);
    }

    public static String formatAsTimestampWithMillis(Date date) {
        return DateTimeUtils.simpleDateFormatTimestampWithMillis().format(date);
    }

    public static String formatAsTimestampWithMicros(Date date) {
        return DateTimeUtils.simpleDateFormatTimestampWithMicros().format(date);
    }

    public static String wrapAsJdbcDateLiteral(String literal) {
        return JDBC_ESCAPE_START_DATE + literal + JDBC_ESCAPE_END;
    }

    public static String wrapAsJdbcTimeLiteral(String literal) {
        return JDBC_ESCAPE_START_TIME + literal + JDBC_ESCAPE_END;
    }

    public static String wrapAsJdbcTimestampLiteral(String literal) {
        return JDBC_ESCAPE_START_TIMESTAMP + literal + JDBC_ESCAPE_END;
    }

    public static String wrapAsAnsiDateLiteral(String literal) {
        return "date '" + literal + "'";
    }

    public static String wrapAsAnsiTimeLiteral(String literal) {
        return "time '" + literal + "'";
    }

    public static String wrapAsAnsiTimestampLiteral(String literal) {
        return "timestamp '" + literal + "'";
    }

    public static SimpleDateFormat simpleDateFormatTimestampWithMillis() {
        return new SimpleDateFormat(FORMAT_STRING_TIMESTAMP_WITH_MILLIS, Locale.ENGLISH);
    }

    public static SimpleDateFormat simpleDateFormatTimestampWithMicros() {
        return new SimpleDateFormat(FORMAT_STRING_TIMESTAMP_WITH_MICROS, Locale.ENGLISH);
    }

    public static String formatAsDate(Date date) {
        return DateTimeUtils.simpleDateFormatDate().format(date);
    }

    public static SimpleDateFormat simpleDateFormatDate() {
        return new SimpleDateFormat(FORMAT_STRING_DATE, Locale.ENGLISH);
    }

    public static String formatAsTime(Date date) {
        return DateTimeUtils.simpleDateFormatTime().format(date);
    }

    public static SimpleDateFormat simpleDateFormatTime() {
        return new SimpleDateFormat(FORMAT_STRING_TIME, Locale.ENGLISH);
    }

    public static String formatAsTimestampWithMillis(Calendar calendar) {
        return DateTimeUtils.simpleDateFormatTimestampWithMillis(calendar.getTimeZone()).format(calendar.getTime());
    }

    public static SimpleDateFormat simpleDateFormatTimestampWithMillis(TimeZone timeZone) {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_STRING_TIMESTAMP_WITH_MILLIS, Locale.ENGLISH);
        formatter.setTimeZone(timeZone);
        return formatter;
    }

    public static String formatAsTimestampWithMicros(Calendar calendar) {
        return DateTimeUtils.simpleDateFormatTimestampWithMicros(calendar.getTimeZone()).format(calendar.getTime());
    }

    public static SimpleDateFormat simpleDateFormatTimestampWithMicros(TimeZone timeZone) {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_STRING_TIMESTAMP_WITH_MICROS, Locale.ENGLISH);
        formatter.setTimeZone(timeZone);
        return formatter;
    }

    public static String formatAsDate(Calendar calendar) {
        return DateTimeUtils.simpleDateFormatDate(calendar.getTimeZone()).format(calendar.getTime());
    }

    public static SimpleDateFormat simpleDateFormatDate(TimeZone timeZone) {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_STRING_DATE, Locale.ENGLISH);
        formatter.setTimeZone(timeZone);
        return formatter;
    }

    public static String formatAsTime(Calendar calendar) {
        return DateTimeUtils.simpleDateFormatTime(calendar.getTimeZone()).format(calendar.getTime());
    }

    public static SimpleDateFormat simpleDateFormatTime(TimeZone timeZone) {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_STRING_TIME, Locale.ENGLISH);
        formatter.setTimeZone(timeZone);
        return formatter;
    }
}

