/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import javax.persistence.TemporalType;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractTemporalTypeDescriptor<T>
extends AbstractTypeDescriptor<T>
implements TemporalJavaTypeDescriptor<T> {
    protected AbstractTemporalTypeDescriptor(Class<T> type) {
        super(type);
    }

    protected AbstractTemporalTypeDescriptor(Class<T> type, MutabilityPlan<T> mutabilityPlan) {
        super(type, mutabilityPlan);
    }

    @Override
    public final <X> TemporalJavaTypeDescriptor<X> resolveTypeForPrecision(TemporalType precision, TypeConfiguration typeConfiguration) {
        if (precision == null) {
            return this.forMissingPrecision(typeConfiguration);
        }
        switch (precision) {
            case DATE: {
                return this.forDatePrecision(typeConfiguration);
            }
            case TIME: {
                return this.forTimePrecision(typeConfiguration);
            }
            case TIMESTAMP: {
                return this.forTimestampPrecision(typeConfiguration);
            }
        }
        throw new IllegalArgumentException("Unrecognized JPA TemporalType precision [" + precision + "]");
    }

    private <X> TemporalJavaTypeDescriptor<X> forMissingPrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    protected <X> TemporalJavaTypeDescriptor<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        throw new UnsupportedOperationException(this.toString() + " as `javax.persistence.TemporalType.TIMESTAMP` not supported");
    }

    protected <X> TemporalJavaTypeDescriptor<X> forDatePrecision(TypeConfiguration typeConfiguration) {
        throw new UnsupportedOperationException(this.toString() + " as `javax.persistence.TemporalType.DATE` not supported");
    }

    protected <X> TemporalJavaTypeDescriptor<X> forTimePrecision(TypeConfiguration typeConfiguration) {
        throw new UnsupportedOperationException(this.toString() + " as `javax.persistence.TemporalType.TIME` not supported");
    }

    public String toString() {
        return "TemporalJavaTypeDescriptor(javaType=" + this.getJavaType().getName() + ")";
    }
}

