/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import javax.persistence.EnumType;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTypeDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.sql.IntegerTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.TinyIntTypeDescriptor;
import org.hibernate.type.descriptor.sql.VarcharTypeDescriptor;

public class EnumJavaTypeDescriptor<T extends Enum<T>>
extends AbstractTypeDescriptor<T> {
    public EnumJavaTypeDescriptor(Class<T> type) {
        super(type, ImmutableMutabilityPlan.INSTANCE);
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators context) {
        if (context.getEnumeratedType() != null && context.getEnumeratedType() == EnumType.STRING) {
            return context.isNationalized() ? context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(-9) : context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(12);
        }
        return context.getTypeConfiguration().getSqlTypeDescriptorRegistry().getDescriptor(-6);
    }

    @Override
    public String toString(T value) {
        return value == null ? "<null>" : ((Enum)value).name();
    }

    @Override
    public T fromString(String string) {
        return string == null ? null : (T)Enum.valueOf(this.getJavaType(), string);
    }

    @Override
    public <X> X unwrap(T value, Class<X> type, WrapperOptions options) {
        if (String.class.equals(type)) {
            return (X)this.toName(value);
        }
        if (Integer.class.equals(type)) {
            return (X)this.toInteger(value);
        }
        if (Byte.class.equals(type)) {
            return (X)this.toByte(value);
        }
        return (X)value;
    }

    @Override
    public <X> T wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.fromName((String)value);
        }
        if (value instanceof Integer) {
            return this.fromInteger((Integer)value);
        }
        if (value instanceof Byte) {
            return this.fromByte((Byte)value);
        }
        return (T)((Enum)value);
    }

    public Byte toByte(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return (byte)((Enum)domainForm).ordinal();
    }

    public Integer toInteger(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return ((Enum)domainForm).ordinal();
    }

    public Integer toOrdinal(T domainForm) {
        return this.toInteger(domainForm);
    }

    public T fromByte(Byte relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((Enum[])this.getJavaType().getEnumConstants())[relationalForm];
    }

    public T fromInteger(Integer relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return (T)((Enum[])this.getJavaType().getEnumConstants())[relationalForm];
    }

    public T fromOrdinal(Integer relationalForm) {
        return this.fromInteger(relationalForm);
    }

    public String toName(T domainForm) {
        if (domainForm == null) {
            return null;
        }
        return ((Enum)domainForm).name();
    }

    public T fromName(String relationalForm) {
        if (relationalForm == null) {
            return null;
        }
        return Enum.valueOf(this.getJavaType(), relationalForm.trim());
    }

    @Override
    public String getCheckCondition(String columnName, SqlTypeDescriptor sqlTypeDescriptor, Dialect dialect) {
        if (sqlTypeDescriptor instanceof TinyIntTypeDescriptor || sqlTypeDescriptor instanceof IntegerTypeDescriptor) {
            int last = ((Enum[])this.getJavaType().getEnumConstants()).length - 1;
            return columnName + " between 0 and " + last;
        }
        if (sqlTypeDescriptor instanceof VarcharTypeDescriptor) {
            StringBuilder types = new StringBuilder();
            for (Enum value : (Enum[])this.getJavaType().getEnumConstants()) {
                if (types.length() != 0) {
                    types.append(", ");
                }
                types.append("'").append(value.name()).append("'");
            }
            return columnName + " in (" + types + ")";
        }
        return null;
    }
}

