/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractTemporalTypeDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.DateTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.TimeTypeDescriptor;
import org.hibernate.type.descriptor.sql.TimestampWithTimeZoneDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class OffsetDateTimeJavaDescriptor
extends AbstractTemporalTypeDescriptor<OffsetDateTime> {
    public static final OffsetDateTimeJavaDescriptor INSTANCE = new OffsetDateTimeJavaDescriptor();

    public OffsetDateTimeJavaDescriptor() {
        super(OffsetDateTime.class, ImmutableMutabilityPlan.INSTANCE);
    }

    @Override
    public TemporalType getPrecision() {
        return TemporalType.TIMESTAMP;
    }

    @Override
    public SqlTypeDescriptor getJdbcRecommendedSqlType(SqlTypeDescriptorIndicators stdIndicators) {
        TemporalType temporalPrecision = stdIndicators.getTemporalPrecision();
        if (temporalPrecision == null || temporalPrecision == TemporalType.TIMESTAMP) {
            return TimestampWithTimeZoneDescriptor.INSTANCE;
        }
        switch (temporalPrecision) {
            case TIME: {
                return TimeTypeDescriptor.INSTANCE;
            }
            case DATE: {
                return DateTypeDescriptor.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Unexpected javax.persistence.TemporalType : " + temporalPrecision);
    }

    @Override
    protected <X> TemporalJavaTypeDescriptor<X> forTimestampPrecision(TypeConfiguration typeConfiguration) {
        return this;
    }

    @Override
    public String toString(OffsetDateTime value) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(value);
    }

    @Override
    public OffsetDateTime fromString(String string) {
        return OffsetDateTime.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(string));
    }

    @Override
    public <X> X unwrap(OffsetDateTime offsetDateTime, Class<X> type, WrapperOptions options) {
        if (offsetDateTime == null) {
            return null;
        }
        if (OffsetDateTime.class.isAssignableFrom(type)) {
            return (X)offsetDateTime;
        }
        if (ZonedDateTime.class.isAssignableFrom(type)) {
            return (X)offsetDateTime.toZonedDateTime();
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return (X)GregorianCalendar.from(offsetDateTime.toZonedDateTime());
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            if (offsetDateTime.getYear() < 1905) {
                return (X)Timestamp.valueOf(offsetDateTime.atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime());
            }
            return (X)Timestamp.from(offsetDateTime.toInstant());
        }
        if (Date.class.isAssignableFrom(type)) {
            return (X)Date.from(offsetDateTime.toInstant());
        }
        if (Time.class.isAssignableFrom(type)) {
            return (X)Time.from(offsetDateTime.toInstant());
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return (X)java.util.Date.from(offsetDateTime.toInstant());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(offsetDateTime.toInstant().toEpochMilli());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> OffsetDateTime wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (OffsetDateTime.class.isInstance(value)) {
            return (OffsetDateTime)value;
        }
        if (ZonedDateTime.class.isInstance(value)) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)value;
            return OffsetDateTime.of(zonedDateTime.toLocalDateTime(), zonedDateTime.getOffset());
        }
        if (Timestamp.class.isInstance(value)) {
            Timestamp ts = (Timestamp)value;
            if (ts.getYear() < 5) {
                return ts.toLocalDateTime().atZone(ZoneId.systemDefault()).toOffsetDateTime();
            }
            return OffsetDateTime.ofInstant(ts.toInstant(), ZoneId.systemDefault());
        }
        if (java.util.Date.class.isInstance(value)) {
            java.util.Date date = (java.util.Date)value;
            return OffsetDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        if (Long.class.isInstance(value)) {
            return OffsetDateTime.ofInstant(Instant.ofEpochMilli((Long)value), ZoneId.systemDefault());
        }
        if (Calendar.class.isInstance(value)) {
            Calendar calendar = (Calendar)value;
            return OffsetDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect) {
        return dialect.getDefaultTimestampPrecision();
    }
}

