/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.archive.spi.InputStreamAccess;
import org.hibernate.boot.internal.MetadataBuilderImpl;
import org.hibernate.boot.jaxb.internal.XmlSources;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.jaxb.spi.XmlSource;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuilderFactory;
import org.hibernate.boot.spi.MetadataBuilderImplementor;
import org.hibernate.boot.spi.XmlMappingBinderAccess;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.SerializationException;
import org.w3c.dom.Document;

public class MetadataSources
implements Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(MetadataSources.class);
    private final ServiceRegistry serviceRegistry;
    private final ClassLoaderService classLoaderService;
    private XmlMappingBinderAccess xmlMappingBinderAccess;
    private List<Binding<?>> xmlBindings;
    private LinkedHashSet<Class<?>> annotatedClasses;
    private LinkedHashSet<String> annotatedClassNames;
    private LinkedHashSet<String> annotatedPackages;
    private Map<String, Class<?>> extraQueryImports;

    public MetadataSources() {
        this(new BootstrapServiceRegistryBuilder().build());
    }

    public MetadataSources(ServiceRegistry serviceRegistry) {
        if (!MetadataSources.isExpectedServiceRegistryType(serviceRegistry) && LOG.isDebugEnabled()) {
            LOG.debugf("Unexpected ServiceRegistry type [%s] encountered during building of MetadataSources; may cause problems later attempting to construct MetadataBuilder", serviceRegistry.getClass().getName());
        }
        this.serviceRegistry = serviceRegistry;
        this.classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
    }

    protected static boolean isExpectedServiceRegistryType(ServiceRegistry serviceRegistry) {
        return serviceRegistry instanceof BootstrapServiceRegistry || serviceRegistry instanceof StandardServiceRegistry;
    }

    public XmlMappingBinderAccess getXmlMappingBinderAccess() {
        if (this.xmlMappingBinderAccess == null) {
            this.xmlMappingBinderAccess = new XmlMappingBinderAccess(this.serviceRegistry);
        }
        return this.xmlMappingBinderAccess;
    }

    public List<Binding<?>> getXmlBindings() {
        return this.xmlBindings == null ? Collections.emptyList() : this.xmlBindings;
    }

    public Collection<String> getAnnotatedPackages() {
        return this.annotatedPackages == null ? Collections.emptySet() : this.annotatedPackages;
    }

    public Collection<Class<?>> getAnnotatedClasses() {
        return this.annotatedClasses == null ? Collections.emptySet() : this.annotatedClasses;
    }

    public Collection<String> getAnnotatedClassNames() {
        return this.annotatedClassNames == null ? Collections.emptySet() : this.annotatedClassNames;
    }

    public Map<String, Class<?>> getExtraQueryImports() {
        return this.extraQueryImports;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public MetadataBuilder getMetadataBuilder() {
        MetadataBuilderImpl defaultBuilder = new MetadataBuilderImpl(this);
        return this.getCustomBuilderOrDefault(defaultBuilder);
    }

    @Deprecated
    public MetadataBuilder getMetadataBuilder(StandardServiceRegistry serviceRegistry) {
        MetadataBuilderImpl defaultBuilder = new MetadataBuilderImpl(this, serviceRegistry);
        return this.getCustomBuilderOrDefault(defaultBuilder);
    }

    private MetadataBuilder getCustomBuilderOrDefault(MetadataBuilderImpl defaultBuilder) {
        ClassLoaderService cls = this.serviceRegistry.getService(ClassLoaderService.class);
        Collection<MetadataBuilderFactory> discoveredBuilderFactories = cls.loadJavaServices(MetadataBuilderFactory.class);
        MetadataBuilderImplementor builder = null;
        ArrayList<String> activeFactoryNames = null;
        for (MetadataBuilderFactory discoveredBuilderFactory : discoveredBuilderFactories) {
            MetadataBuilderImplementor returnedBuilder = discoveredBuilderFactory.getMetadataBuilder(this, defaultBuilder);
            if (returnedBuilder == null) continue;
            if (activeFactoryNames == null) {
                activeFactoryNames = new ArrayList<String>();
            }
            activeFactoryNames.add(discoveredBuilderFactory.getClass().getName());
            builder = returnedBuilder;
        }
        if (activeFactoryNames != null && activeFactoryNames.size() > 1) {
            throw new HibernateException("Multiple active MetadataBuilder definitions were discovered : " + String.join((CharSequence)", ", (Iterable<? extends CharSequence>)activeFactoryNames));
        }
        return builder != null ? builder : defaultBuilder;
    }

    public Metadata buildMetadata() {
        return this.getMetadataBuilder().build();
    }

    public Metadata buildMetadata(StandardServiceRegistry serviceRegistry) {
        return this.getMetadataBuilder(serviceRegistry).build();
    }

    public MetadataSources addAnnotatedClass(Class annotatedClass) {
        if (this.annotatedClasses == null) {
            this.annotatedClasses = new LinkedHashSet();
        }
        this.annotatedClasses.add(annotatedClass);
        return this;
    }

    public MetadataSources addAnnotatedClasses(Class<?> ... annotatedClasses) {
        if (annotatedClasses != null && annotatedClasses.length > 0) {
            if (this.annotatedClasses == null) {
                this.annotatedClasses = new LinkedHashSet();
            }
            Collections.addAll(this.annotatedClasses, annotatedClasses);
        }
        return this;
    }

    public MetadataSources addAnnotatedClassName(String annotatedClassName) {
        if (this.annotatedClassNames == null) {
            this.annotatedClassNames = new LinkedHashSet();
        }
        this.annotatedClassNames.add(annotatedClassName);
        return this;
    }

    public MetadataSources addAnnotatedClassNames(String ... annotatedClassNames) {
        if (annotatedClassNames != null && annotatedClassNames.length > 0) {
            Collections.addAll(this.annotatedClassNames, annotatedClassNames);
        }
        return this;
    }

    public MetadataSources addQueryImport(String importedName, Class<?> target) {
        if (this.extraQueryImports == null) {
            this.extraQueryImports = new HashMap();
        }
        this.extraQueryImports.put(importedName, target);
        return this;
    }

    public MetadataSources addPackage(String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("The specified package name cannot be null");
        }
        if (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        this.addPackageInternal(packageName);
        return this;
    }

    private void addPackageInternal(String packageName) {
        if (this.annotatedPackages == null) {
            this.annotatedPackages = new LinkedHashSet();
        }
        this.annotatedPackages.add(packageName);
    }

    public MetadataSources addPackage(Package packageRef) {
        this.addPackageInternal(packageRef.getName());
        return this;
    }

    @Deprecated
    public MetadataSources addClass(Class entityClass) {
        if (entityClass == null) {
            throw new IllegalArgumentException("The specified class cannot be null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("adding resource mappings from class convention : %s", entityClass.getName());
        }
        String mappingResourceName = entityClass.getName().replace('.', '/') + ".hbm.xml";
        this.addResource(mappingResourceName);
        return this;
    }

    public MetadataSources addResource(String name) {
        XmlSource xmlSource = XmlSources.fromResource(name, this.classLoaderService);
        XmlMappingBinderAccess binderAccess = this.getXmlMappingBinderAccess();
        this.getXmlBindingsForWrite().add(xmlSource.doBind(binderAccess.getMappingBinder()));
        return this;
    }

    public MetadataSources addFile(String path) {
        this.addFile(new File(path));
        return this;
    }

    public MetadataSources addFile(File file) {
        XmlSource xmlSource = XmlSources.fromFile(file);
        XmlMappingBinderAccess binderAccess = this.getXmlMappingBinderAccess();
        this.getXmlBindingsForWrite().add(xmlSource.doBind(binderAccess.getMappingBinder()));
        return this;
    }

    public MetadataSources addCacheableFile(String path) {
        this.addCacheableFile(new File(path));
        return this;
    }

    public MetadataSources addCacheableFile(File file) {
        XmlSource xmlSource = XmlSources.fromCacheableFile(file);
        XmlMappingBinderAccess binderAccess = this.getXmlMappingBinderAccess();
        this.getXmlBindingsForWrite().add(xmlSource.doBind(binderAccess.getMappingBinder()));
        return this;
    }

    public MetadataSources addCacheableFileStrictly(File file) throws SerializationException {
        XmlSource xmlSource = XmlSources.fromCacheableFile(file, true);
        XmlMappingBinderAccess binderAccess = this.getXmlMappingBinderAccess();
        this.getXmlBindingsForWrite().add(xmlSource.doBind(binderAccess.getMappingBinder()));
        return this;
    }

    public MetadataSources addInputStream(InputStreamAccess xmlInputStreamAccess) {
        XmlSource xmlSource = XmlSources.fromStream(xmlInputStreamAccess);
        XmlMappingBinderAccess binderAccess = this.getXmlMappingBinderAccess();
        this.getXmlBindingsForWrite().add(xmlSource.doBind(binderAccess.getMappingBinder()));
        return this;
    }

    public MetadataSources addInputStream(InputStream xmlInputStream) {
        XmlSource xmlSource = XmlSources.fromStream(xmlInputStream);
        XmlMappingBinderAccess binderAccess = this.getXmlMappingBinderAccess();
        this.getXmlBindingsForWrite().add(xmlSource.doBind(binderAccess.getMappingBinder()));
        return this;
    }

    public MetadataSources addURL(URL url) {
        XmlSource xmlSource = XmlSources.fromUrl(url);
        XmlMappingBinderAccess binderAccess = this.getXmlMappingBinderAccess();
        this.getXmlBindingsForWrite().add(xmlSource.doBind(binderAccess.getMappingBinder()));
        return this;
    }

    @Deprecated
    public MetadataSources addDocument(Document document) {
        XmlSource xmlSource = XmlSources.fromDocument(document);
        XmlMappingBinderAccess binderAccess = this.getXmlMappingBinderAccess();
        this.getXmlBindingsForWrite().add(xmlSource.doBind(binderAccess.getMappingBinder()));
        return this;
    }

    public MetadataSources addJar(File jar) {
        XmlMappingBinderAccess binderAccess = this.getXmlMappingBinderAccess();
        XmlSources.fromJar(jar, xmlSource -> this.getXmlBindingsForWrite().add(xmlSource.doBind(binderAccess.getMappingBinder())));
        return this;
    }

    private List<Binding<?>> getXmlBindingsForWrite() {
        if (this.xmlBindings == null) {
            this.xmlBindings = new ArrayList();
        }
        return this.xmlBindings;
    }

    public MetadataSources addDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.addDirectory(file);
                    continue;
                }
                if (!file.getName().endsWith(".hbm.xml")) continue;
                this.addFile(file);
            }
        }
        return this;
    }
}

