/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.boot.model.process.internal.UserTypeResolution;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

public class TypeDefinition
implements Serializable {
    private static final AtomicInteger nameCounter = new AtomicInteger();
    private final String name;
    private final Class typeImplementorClass;
    private final String[] registrationKeys;
    private final Properties parameters;
    private final TypeConfiguration typeConfiguration;
    private BasicValue.Resolution<?> reusableResolution;

    public TypeDefinition(String name, Class typeImplementorClass, String[] registrationKeys, Properties parameters, TypeConfiguration typeConfiguration) {
        this.name = name;
        this.typeImplementorClass = typeImplementorClass;
        this.registrationKeys = registrationKeys;
        this.parameters = parameters;
        this.typeConfiguration = typeConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public Class getTypeImplementorClass() {
        return this.typeImplementorClass;
    }

    public String[] getRegistrationKeys() {
        return this.registrationKeys;
    }

    public Properties getParameters() {
        return this.parameters;
    }

    public Properties getParametersAsProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.parameters);
        return properties;
    }

    public BasicValue.Resolution<?> resolve(Map localConfigParameters, MutabilityPlan explicitMutabilityPlan, MetadataBuildingContext context) {
        if (CollectionHelper.isEmpty(localConfigParameters)) {
            if (this.reusableResolution == null) {
                ManagedBean typeBean = context.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(this.typeImplementorClass);
                Object typeInstance = typeBean.getBeanInstance();
                TypeDefinition.injectParameters(typeInstance, () -> this.parameters);
                this.reusableResolution = TypeDefinition.createReusableResolution(typeInstance, this.name, context);
            }
            return this.reusableResolution;
        }
        String name = this.name + ":" + nameCounter.getAndIncrement();
        ManagedBean typeBean = context.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(name, this.typeImplementorClass);
        Object typeInstance = typeBean.getBeanInstance();
        TypeDefinition.injectParameters(typeInstance, () -> TypeDefinition.mergeParameters(this.parameters, localConfigParameters));
        return TypeDefinition.createResolution(name, typeInstance, explicitMutabilityPlan, context);
    }

    private static Properties mergeParameters(Properties parameters, Map localConfigParameters) {
        Properties mergedParameters = new Properties();
        if (parameters != null) {
            mergedParameters.putAll((Map<?, ?>)parameters);
        }
        if (localConfigParameters != null && !localConfigParameters.isEmpty()) {
            mergedParameters.putAll((Map<?, ?>)localConfigParameters);
        }
        return mergedParameters;
    }

    private static void injectParameters(Object customType, Supplier<Properties> parameterSupplier) {
        Properties parameterValues;
        if (customType instanceof ParameterizedType && (parameterValues = parameterSupplier.get()) != null) {
            ((ParameterizedType)customType).setParameterValues(parameterValues);
        }
    }

    public static BasicValue.Resolution<?> createReusableResolution(Object namedTypeInstance, String name, MetadataBuildingContext buildingContext) {
        if (namedTypeInstance instanceof UserType) {
            UserType userType = (UserType)namedTypeInstance;
            CustomType customType = new CustomType(userType, buildingContext.getBootstrapContext().getTypeConfiguration());
            return new UserTypeResolution(customType, null);
        }
        if (namedTypeInstance instanceof BasicType) {
            final BasicType resolvedBasicType = (BasicType)namedTypeInstance;
            return new BasicValue.Resolution<Object>(){

                @Override
                public JdbcMapping getJdbcMapping() {
                    return resolvedBasicType;
                }

                @Override
                public BasicType getLegacyResolvedBasicType() {
                    return resolvedBasicType;
                }

                @Override
                public JavaTypeDescriptor<Object> getDomainJavaDescriptor() {
                    return resolvedBasicType.getMappedJavaTypeDescriptor();
                }

                @Override
                public JavaTypeDescriptor<?> getRelationalJavaDescriptor() {
                    return resolvedBasicType.getMappedJavaTypeDescriptor();
                }

                @Override
                public SqlTypeDescriptor getRelationalSqlTypeDescriptor() {
                    return resolvedBasicType.getSqlTypeDescriptor();
                }

                @Override
                public BasicValueConverter getValueConverter() {
                    return null;
                }

                @Override
                public MutabilityPlan<Object> getMutabilityPlan() {
                    return resolvedBasicType.isMutable() ? this.getDomainJavaDescriptor().getMutabilityPlan() : ImmutableMutabilityPlan.instance();
                }
            };
        }
        throw new IllegalArgumentException("Named type [" + namedTypeInstance + "] did not implement BasicType nor UserType");
    }

    public static BasicValue.Resolution<?> createLocalResolution(String name, Class typeImplementorClass, MutabilityPlan explicitMutabilityPlan, Map localTypeParams, MetadataBuildingContext buildingContext) {
        name = name + ':' + nameCounter.getAndIncrement();
        ManagedBean typeBean = buildingContext.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class).getBean(name, typeImplementorClass);
        Object typeInstance = typeBean.getBeanInstance();
        TypeDefinition.injectParameters(typeInstance, () -> CollectionHelper.asProperties(localTypeParams));
        return TypeDefinition.createResolution(name, typeInstance, explicitMutabilityPlan, buildingContext);
    }

    private static BasicValue.Resolution<?> createResolution(String name, Object namedTypeInstance, MutabilityPlan explicitMutabilityPlan, MetadataBuildingContext metadataBuildingContext) {
        if (namedTypeInstance instanceof UserType) {
            return new UserTypeResolution(new CustomType((UserType)namedTypeInstance, metadataBuildingContext.getBootstrapContext().getTypeConfiguration()), null);
        }
        if (namedTypeInstance instanceof BasicType) {
            final BasicType resolvedBasicType = (BasicType)namedTypeInstance;
            return new BasicValue.Resolution<Object>(){

                @Override
                public JdbcMapping getJdbcMapping() {
                    return resolvedBasicType;
                }

                @Override
                public BasicType getLegacyResolvedBasicType() {
                    return resolvedBasicType;
                }

                @Override
                public JavaTypeDescriptor<Object> getDomainJavaDescriptor() {
                    return resolvedBasicType.getMappedJavaTypeDescriptor();
                }

                @Override
                public JavaTypeDescriptor<?> getRelationalJavaDescriptor() {
                    return resolvedBasicType.getMappedJavaTypeDescriptor();
                }

                @Override
                public SqlTypeDescriptor getRelationalSqlTypeDescriptor() {
                    return resolvedBasicType.getSqlTypeDescriptor();
                }

                @Override
                public BasicValueConverter getValueConverter() {
                    return null;
                }

                @Override
                public MutabilityPlan<Object> getMutabilityPlan() {
                    throw new NotYetImplementedFor6Exception(this.getClass());
                }
            };
        }
        throw new IllegalArgumentException("Named type [" + name + " : " + namedTypeInstance + "] did not implement BasicType nor UserType");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeDefinition)) {
            return false;
        }
        TypeDefinition that = (TypeDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.typeImplementorClass, that.typeImplementorClass) && Arrays.equals(this.registrationKeys, that.registrationKeys) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.typeImplementorClass != null ? this.typeImplementorClass.hashCode() : 0);
        result = 31 * result + (this.registrationKeys != null ? Arrays.hashCode(this.registrationKeys) : 0);
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TypeDefinition{name='" + this.name + '\'' + ", typeImplementorClass=" + this.typeImplementorClass + ", registrationKeys=" + Arrays.toString(this.registrationKeys) + ", parameters=" + this.parameters + '}';
    }
}

