/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.hibernate.NullPrecedence;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.DB2FormatEmulation;
import org.hibernate.dialect.identity.DB2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.DB2LimitHandler;
import org.hibernate.dialect.pagination.LegacyDB2LimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.sequence.DB2SequenceSupport;
import org.hibernate.dialect.sequence.LegacyDB2SequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.unique.DB2UniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.TempIdTableExporter;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorDB2DatabaseImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.sql.CharTypeDescriptor;
import org.hibernate.type.descriptor.sql.ClobTypeDescriptor;
import org.hibernate.type.descriptor.sql.DecimalTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.VarcharTypeDescriptor;

public class DB2Dialect
extends Dialect {
    private final int version;
    private LimitHandler limitHandler;
    private final UniqueDelegate uniqueDelegate;

    public DB2Dialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10);
    }

    public DB2Dialect() {
        this(900);
    }

    public DB2Dialect(int version) {
        this.version = version;
        this.registerColumnType(-7, 1L, "boolean");
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(2, "decimal($p,$s)");
        if (this.getVersion() < 1100) {
            this.registerColumnType(-2, "varchar($l) for bit data");
            this.registerColumnType(-2, 254L, "char($l) for bit data");
            this.registerColumnType(-3, "varchar($l) for bit data");
        }
        this.registerColumnType(2004, "blob($l)");
        this.registerColumnType(2005, "clob($l)");
        this.registerColumnType(2014, "timestamp($p)");
        this.registerKeyword("current");
        this.registerKeyword("date");
        this.registerKeyword("time");
        this.registerKeyword("timestamp");
        this.registerKeyword("fetch");
        this.registerKeyword("first");
        this.registerKeyword("rows");
        this.registerKeyword("only");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
        this.uniqueDelegate = new DB2UniqueDelegate(this);
        this.limitHandler = this.getVersion() < 1110 ? LegacyDB2LimitHandler.INSTANCE : DB2LimitHandler.INSTANCE;
    }

    @Override
    public int getDefaultDecimalPrecision() {
        return 31;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.cot(queryEngine);
        CommonFunctionFactory.degrees(queryEngine);
        CommonFunctionFactory.log(queryEngine);
        CommonFunctionFactory.log10(queryEngine);
        CommonFunctionFactory.radians(queryEngine);
        CommonFunctionFactory.rand(queryEngine);
        CommonFunctionFactory.soundex(queryEngine);
        CommonFunctionFactory.trim2(queryEngine);
        CommonFunctionFactory.space(queryEngine);
        CommonFunctionFactory.repeat(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.translate(queryEngine);
        CommonFunctionFactory.bitand(queryEngine);
        CommonFunctionFactory.bitor(queryEngine);
        CommonFunctionFactory.bitxor(queryEngine);
        CommonFunctionFactory.bitnot(queryEngine);
        CommonFunctionFactory.yearMonthDay(queryEngine);
        CommonFunctionFactory.hourMinuteSecond(queryEngine);
        CommonFunctionFactory.dayofweekmonthyear(queryEngine);
        CommonFunctionFactory.weekQuarter(queryEngine);
        CommonFunctionFactory.daynameMonthname(queryEngine);
        CommonFunctionFactory.lastDay(queryEngine);
        CommonFunctionFactory.toCharNumberDateTimestamp(queryEngine);
        CommonFunctionFactory.dateTimeTimestamp(queryEngine);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.ascii(queryEngine);
        CommonFunctionFactory.char_chr(queryEngine);
        CommonFunctionFactory.position(queryEngine);
        CommonFunctionFactory.trunc(queryEngine);
        CommonFunctionFactory.truncate(queryEngine);
        CommonFunctionFactory.insert(queryEngine);
        CommonFunctionFactory.overlayCharacterLength_overlay(queryEngine);
        CommonFunctionFactory.median(queryEngine);
        CommonFunctionFactory.stddev(queryEngine);
        CommonFunctionFactory.stddevPopSamp(queryEngine);
        CommonFunctionFactory.variance(queryEngine);
        CommonFunctionFactory.stdevVarianceSamp(queryEngine);
        CommonFunctionFactory.addYearsMonthsDaysHoursMinutesSeconds(queryEngine);
        CommonFunctionFactory.yearsMonthsDaysHoursMinutesSecondsBetween(queryEngine);
        CommonFunctionFactory.dateTrunc(queryEngine);
        queryEngine.getSqmFunctionRegistry().register("format", new DB2FormatEmulation());
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("posstr").setInvariantType(StandardBasicTypes.INTEGER).setExactArgumentCount(2).setArgumentListSignature("(string, pattern)").register();
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1000000000L;
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, boolean fromTimestamp, boolean toTimestamp) {
        StringBuilder pattern = new StringBuilder();
        boolean castFrom = !fromTimestamp && !unit.isDateUnit();
        boolean castTo = !toTimestamp && !unit.isDateUnit();
        switch (unit) {
            case NATIVE: 
            case NANOSECOND: {
                pattern.append("(seconds_between(");
                break;
            }
            case MONTH: 
            case QUARTER: {
                pattern.append("trunc(months_between(");
                break;
            }
            default: {
                pattern.append("?1s_between(");
            }
        }
        if (castTo) {
            pattern.append("cast(?3 as timestamp)");
        } else {
            pattern.append("?3");
        }
        pattern.append(",");
        if (castFrom) {
            pattern.append("cast(?2 as timestamp)");
        } else {
            pattern.append("?2");
        }
        pattern.append(")");
        switch (unit) {
            case NATIVE: {
                pattern.append("+(microsecond(?3)-microsecond(?2))/1e6)");
                break;
            }
            case NANOSECOND: {
                pattern.append("*1e9+(microsecond(?3)-microsecond(?2))*1e3)");
                break;
            }
            case MONTH: {
                pattern.append(")");
                break;
            }
            case QUARTER: {
                pattern.append("/3)");
            }
        }
        return pattern.toString();
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, boolean timestamp) {
        StringBuilder pattern = new StringBuilder();
        boolean castTo = !timestamp && !unit.isDateUnit();
        pattern.append("add_");
        switch (unit) {
            case NATIVE: 
            case NANOSECOND: {
                pattern.append("second");
                break;
            }
            case WEEK: {
                pattern.append("day");
                break;
            }
            case QUARTER: {
                pattern.append("month");
                break;
            }
            default: {
                pattern.append("?1");
            }
        }
        pattern.append("s(");
        if (castTo) {
            pattern.append("cast(?3 as timestamp)");
        } else {
            pattern.append("?3");
        }
        pattern.append(",");
        switch (unit) {
            case NANOSECOND: {
                pattern.append("(?2)/1e9");
                break;
            }
            case WEEK: {
                pattern.append("(?2)*7");
                break;
            }
            case QUARTER: {
                pattern.append("(?2)*3");
                break;
            }
            default: {
                pattern.append("?2");
            }
        }
        pattern.append(")");
        return pattern.toString();
    }

    @Override
    public String getLowercaseFunction() {
        return this.getVersion() < 970 ? "lcase" : super.getLowercaseFunction();
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getVersion() < 970 ? LegacyDB2SequenceSupport.INSTANCE : DB2SequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from syscat.sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        if (this.getQuerySequencesString() == null) {
            return SequenceInformationExtractorNoOpImpl.INSTANCE;
        }
        return SequenceInformationExtractorDB2DatabaseImpl.INSTANCE;
    }

    @Override
    public String getForUpdateString() {
        return " for read only with rs use and keep update locks";
    }

    @Override
    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    @Override
    public boolean supportsExistsInSelect() {
        return false;
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public String getSelectClauseNullString(int sqlType) {
        return DB2Dialect.selectNullString(sqlType);
    }

    static String selectNullString(int sqlType) {
        String literal;
        switch (sqlType) {
            case 1: 
            case 12: {
                literal = "''";
                break;
            }
            case 91: {
                literal = "'2000-1-1'";
                break;
            }
            case 92: {
                literal = "'00:00:00'";
                break;
            }
            case 93: 
            case 2014: {
                literal = "'2000-1-1 00:00:00'";
                break;
            }
            default: {
                literal = "0";
            }
        }
        return "nullif(" + literal + ", " + literal + ')';
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    @Override
    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    @Override
    public boolean supportsCommentOn() {
        return true;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        if (this.getVersion() >= 970) {
            return new GlobalTemporaryTableStrategy(new IdTable(rootEntityDescriptor, name -> "HT_" + name), () -> new TempIdTableExporter(false, this::getTypeName){

                @Override
                protected String getCreateOptions() {
                    return "not logged";
                }
            }, AfterUseAction.CLEAN, runtimeModelCreationContext.getSessionFactory());
        }
        return super.getFallbackSqmMutationStrategy(rootEntityDescriptor, runtimeModelCreationContext);
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "values current timestamp";
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public boolean supportsParametersInInsertSelect() {
        return true;
    }

    @Override
    public boolean requiresCastingOfParametersInSelectClause() {
        return true;
    }

    @Override
    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    @Override
    public String getCrossJoinSeparator() {
        return this.getVersion() < 970 ? ", " : super.getCrossJoinSeparator();
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    @Override
    public String getFromDual() {
        return "from sysibm.dual";
    }

    @Override
    protected SqlTypeDescriptor getSqlTypeDescriptorOverride(int sqlCode) {
        if (this.getVersion() < 970) {
            return sqlCode == 2 ? DecimalTypeDescriptor.INSTANCE : super.getSqlTypeDescriptorOverride(sqlCode);
        }
        switch (sqlCode) {
            case -15: {
                return CharTypeDescriptor.INSTANCE;
            }
            case 2011: {
                return this.useInputStreamToInsertBlob() ? ClobTypeDescriptor.STREAM_BINDING : ClobTypeDescriptor.CLOB_BINDING;
            }
            case -9: {
                return VarcharTypeDescriptor.INSTANCE;
            }
            case 2: {
                return DecimalTypeDescriptor.INSTANCE;
            }
        }
        return super.getSqlTypeDescriptorOverride(sqlCode);
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
            if (-952 == errorCode && "57014".equals(sqlState)) {
                throw new LockTimeoutException(message, sqlException, sql);
            }
            return null;
        };
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public String getNotExpression(String expression) {
        return "not (" + expression + ")";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public String renderOrderByElement(String expression, String collation, String order, NullPrecedence nullPrecedence) {
        if (nullPrecedence == null || nullPrecedence == NullPrecedence.NONE) {
            return super.renderOrderByElement(expression, collation, order, NullPrecedence.NONE);
        }
        if (nullPrecedence == NullPrecedence.FIRST && "desc".equalsIgnoreCase(order) || nullPrecedence == NullPrecedence.LAST && "asc".equalsIgnoreCase(order)) {
            return super.renderOrderByElement(expression, collation, order, NullPrecedence.NONE);
        }
        return String.format(Locale.ENGLISH, "case when %s is null then %s else %s end, %s %s", expression, nullPrecedence == NullPrecedence.FIRST ? "0" : "1", nullPrecedence == NullPrecedence.FIRST ? "1" : "0", expression, order);
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new DB2IdentityColumnSupport();
    }

    @Override
    public boolean supportsPartitionBy() {
        return true;
    }

    @Override
    public String translateDatetimeFormat(String format) {
        return OracleDialect.datetimeFormat(format, false).result();
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case DAY_OF_YEAR: {
                return "doy";
            }
            case DAY_OF_WEEK: {
                return "dow";
            }
        }
        return super.translateExtractField(unit);
    }
}

