/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.PessimisticLockException;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.hint.IndexQueryHintHandler;
import org.hibernate.dialect.identity.H2IdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitOffsetLimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.H2SequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.LocalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorH2DatabaseImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorLegacyImpl;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.jboss.logging.Logger;

public class H2Dialect
extends Dialect {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)H2Dialect.class.getName());
    private final LimitHandler limitHandler;
    private final boolean cascadeConstraints;
    private final int version;
    private final SequenceInformationExtractor sequenceInformationExtractor;
    private final String querySequenceString;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        String constraintName = null;
        if (sqle.getSQLState().startsWith("23")) {
            String message = sqle.getMessage();
            int idx = message.indexOf("violation: ");
            if (idx > 0) {
                constraintName = message.substring(idx + "violation: ".length());
            }
            if (sqle.getSQLState().equals("23506")) {
                constraintName = constraintName.substring(1, constraintName.indexOf(":"));
            }
        }
        return constraintName;
    });

    public H2Dialect() {
        this(0, 0);
    }

    public H2Dialect(int version, int buildId) {
        this.version = version;
        LimitHandler limitHandler = this.limitHandler = version > 140 || version == 140 && buildId >= 199 ? OffsetFetchLimitHandler.INSTANCE : LimitOffsetLimitHandler.INSTANCE;
        if (version < 120 || version == 120 && buildId < 139) {
            LOG.unsupportedMultiTableBulkHqlJpaql(version / 100, version % 100 / 10, buildId);
        }
        this.cascadeConstraints = version > 140 || version == 140 && buildId >= 200;
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.jdbc.lob.non_contextual_creation", "true");
        if (buildId >= 32) {
            this.sequenceInformationExtractor = buildId >= 201 ? SequenceInformationExtractorLegacyImpl.INSTANCE : SequenceInformationExtractorH2DatabaseImpl.INSTANCE;
            this.querySequenceString = "select * from INFORMATION_SCHEMA.SEQUENCES";
            this.registerColumnType(3, "numeric($p,$s)");
        } else {
            this.sequenceInformationExtractor = SequenceInformationExtractorNoOpImpl.INSTANCE;
            this.querySequenceString = null;
        }
    }

    private static int parseBuildId(DialectResolutionInfo info) {
        String[] bits = info.getDatabaseVersion().split("[. ]");
        return bits.length > 2 ? Integer.parseInt(bits[2]) : 0;
    }

    public H2Dialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10, H2Dialect.parseBuildId(info));
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.pi(queryEngine);
        CommonFunctionFactory.cot(queryEngine);
        CommonFunctionFactory.radians(queryEngine);
        CommonFunctionFactory.degrees(queryEngine);
        CommonFunctionFactory.log10(queryEngine);
        CommonFunctionFactory.rand(queryEngine);
        CommonFunctionFactory.truncate(queryEngine);
        CommonFunctionFactory.soundex(queryEngine);
        CommonFunctionFactory.translate(queryEngine);
        CommonFunctionFactory.bitand(queryEngine);
        CommonFunctionFactory.bitor(queryEngine);
        CommonFunctionFactory.bitxor(queryEngine);
        CommonFunctionFactory.bitAndOr(queryEngine);
        CommonFunctionFactory.yearMonthDay(queryEngine);
        CommonFunctionFactory.hourMinuteSecond(queryEngine);
        CommonFunctionFactory.dayOfWeekMonthYear(queryEngine);
        CommonFunctionFactory.weekQuarter(queryEngine);
        CommonFunctionFactory.daynameMonthname(queryEngine);
        CommonFunctionFactory.localtimeLocaltimestamp(queryEngine);
        CommonFunctionFactory.bitLength(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.ascii(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.space(queryEngine);
        CommonFunctionFactory.repeat(queryEngine);
        CommonFunctionFactory.chr_char(queryEngine);
        CommonFunctionFactory.instr(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.position(queryEngine);
        CommonFunctionFactory.trim1(queryEngine);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.nowCurdateCurtime(queryEngine);
        CommonFunctionFactory.sysdate(queryEngine);
        CommonFunctionFactory.insert(queryEngine);
        CommonFunctionFactory.everyAny_boolAndOr(queryEngine);
        CommonFunctionFactory.median(queryEngine);
        CommonFunctionFactory.stddevPopSamp(queryEngine);
        CommonFunctionFactory.varPopSamp(queryEngine);
        CommonFunctionFactory.format_formatdatetime(queryEngine);
        CommonFunctionFactory.rownum(queryEngine);
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return unit == TemporalUnit.SECOND ? "(" + super.extractPattern(unit) + "+extract(nanosecond from ?2)/1e9)" : super.extractPattern(unit);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, boolean timestamp) {
        return "dateadd(?1, ?2, ?3)";
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, boolean fromTimestamp, boolean toTimestamp) {
        return "datediff(?1, ?2, ?3)";
    }

    @Override
    public String toBooleanValueString(boolean bool) {
        return String.valueOf(bool);
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    @Override
    public boolean supportsIfExistsAfterTableName() {
        return !this.supportsIfExistsBeforeTableName();
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return this.cascadeConstraints;
    }

    @Override
    public boolean supportsIfExistsAfterAlterTable() {
        return this.cascadeConstraints;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return true;
    }

    @Override
    public String getCascadeConstraintsString() {
        return this.cascadeConstraints ? " cascade " : super.getCascadeConstraintsString();
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return H2SequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.querySequenceString;
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.sequenceInformationExtractor;
    }

    @Override
    public String getFromDual() {
        return "from dual";
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType entityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        return new LocalTemporaryTableStrategy(new IdTable(entityDescriptor, basename -> "HT_" + basename), this::getTypeName, AfterUseAction.CLEAN, TempTableDdlTransactionHandling.NONE, runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            int errorCode = JdbcExceptionHelper.extractErrorCode(sqlException);
            switch (errorCode) {
                case 40001: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 50200: {
                    return new PessimisticLockException(message, sqlException, sql);
                }
                case 90006: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, constraintName);
                }
            }
            return null;
        };
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "call current_timestamp()";
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean requiresParensForTupleDistinctCounts() {
        return true;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    @Override
    public boolean supportsTuplesInSubqueries() {
        return false;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new H2IdentityColumnSupport();
    }

    @Override
    public String getQueryHintString(String query, String hints) {
        return IndexQueryHintHandler.INSTANCE.addQueryHints(query, hints);
    }

    @Override
    public String translateDatetimeFormat(String format) {
        return new Replacer(format, "'", "''").replace("e", "u").result();
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case DAY_OF_MONTH: {
                return "day";
            }
            case WEEK: {
                return "iso_week";
            }
        }
        return unit.toString();
    }
}

