/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.DatabaseMetaData;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.HSQLIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadSelectLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteSelectLockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.pagination.LegacyHSQLLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitOffsetLimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.HSQLSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.query.CastType;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.GlobalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.LocalTemporaryTableStrategy;
import org.hibernate.query.sqm.mutation.internal.idtable.TempIdTableExporter;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorHSQLDBDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.jboss.logging.Logger;

public class HSQLDialect
extends Dialect {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)HSQLDialect.class.getName());
    private final int version;
    private static final ViolatedConstraintNameExtractor EXTRACTOR_18 = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        switch (JdbcExceptionHelper.extractErrorCode(sqle)) {
            case -8: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("Integrity constraint violation ", " table:", sqle.getMessage());
            }
            case -9: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("Violation of unique index: ", " in statement [", sqle.getMessage());
            }
            case -104: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("Unique constraint violation: ", " in statement [", sqle.getMessage());
            }
            case -177: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("Integrity constraint violation - no parent ", " table:", sqle.getMessage());
            }
        }
        return null;
    });
    private static final ViolatedConstraintNameExtractor EXTRACTOR_20 = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        switch (JdbcExceptionHelper.extractErrorCode(sqle)) {
            case -177: 
            case -104: 
            case -9: 
            case -8: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("; ", " table: ", sqle.getMessage());
            }
        }
        return null;
    });

    public HSQLDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10);
    }

    public HSQLDialect() {
        this(180);
    }

    public HSQLDialect(int version) {
        if (version == 180) {
            version = HSQLDialect.reflectedVersion(version);
        }
        this.version = version;
        this.registerColumnType(-1, "longvarchar");
        this.registerColumnType(-4, "longvarbinary");
        this.registerColumnType(2011, "clob");
        if (this.version < 200) {
            this.registerColumnType(2, "numeric");
            this.registerColumnType(2004, "longvarbinary");
            this.registerColumnType(2005, "longvarchar");
        }
        if (this.version >= 250) {
            this.registerKeyword("period");
        }
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    private static int reflectedVersion(int version) {
        try {
            Class props = ReflectHelper.classForName("org.hsqldb.persist.HsqlDatabaseProperties");
            String versionString = (String)props.getDeclaredField("THIS_VERSION").get(null);
            return Integer.parseInt(versionString.substring(0, 1)) * 100 + Integer.parseInt(versionString.substring(2, 3)) * 10 + Integer.parseInt(versionString.substring(4, 5));
        }
        catch (Throwable e) {
            return version;
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.cot(queryEngine);
        CommonFunctionFactory.radians(queryEngine);
        CommonFunctionFactory.degrees(queryEngine);
        CommonFunctionFactory.log10(queryEngine);
        CommonFunctionFactory.rand(queryEngine);
        CommonFunctionFactory.trunc(queryEngine);
        CommonFunctionFactory.truncate(queryEngine);
        CommonFunctionFactory.pi(queryEngine);
        CommonFunctionFactory.soundex(queryEngine);
        CommonFunctionFactory.reverse(queryEngine);
        CommonFunctionFactory.space(queryEngine);
        CommonFunctionFactory.repeat(queryEngine);
        CommonFunctionFactory.translate(queryEngine);
        CommonFunctionFactory.bitand(queryEngine);
        CommonFunctionFactory.bitor(queryEngine);
        CommonFunctionFactory.bitxor(queryEngine);
        CommonFunctionFactory.bitnot(queryEngine);
        CommonFunctionFactory.yearMonthDay(queryEngine);
        CommonFunctionFactory.hourMinuteSecond(queryEngine);
        CommonFunctionFactory.dayofweekmonthyear(queryEngine);
        CommonFunctionFactory.weekQuarter(queryEngine);
        CommonFunctionFactory.daynameMonthname(queryEngine);
        CommonFunctionFactory.lastDay(queryEngine);
        CommonFunctionFactory.trim1(queryEngine);
        CommonFunctionFactory.toCharNumberDateTimestamp(queryEngine);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.localtimeLocaltimestamp(queryEngine);
        CommonFunctionFactory.bitLength(queryEngine);
        CommonFunctionFactory.octetLength(queryEngine);
        CommonFunctionFactory.ascii(queryEngine);
        CommonFunctionFactory.chr_char(queryEngine);
        CommonFunctionFactory.instr(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.position(queryEngine);
        CommonFunctionFactory.nowCurdateCurtime(queryEngine);
        CommonFunctionFactory.insert(queryEngine);
        CommonFunctionFactory.overlay(queryEngine);
        CommonFunctionFactory.median(queryEngine);
        CommonFunctionFactory.stddevPopSamp(queryEngine);
        CommonFunctionFactory.varPopSamp(queryEngine);
        CommonFunctionFactory.addMonths(queryEngine);
        CommonFunctionFactory.monthsBetween(queryEngine);
        if (this.version >= 200) {
            CommonFunctionFactory.sysdate(queryEngine);
        }
        if (this.version > 219) {
            CommonFunctionFactory.rownum(queryEngine);
        }
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (from == CastType.BOOLEAN && (to == CastType.INTEGER || to == CastType.LONG)) {
            return "casewhen(?1,1,0)";
        }
        return super.castPattern(from, to);
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, boolean timestamp) {
        StringBuilder pattern = new StringBuilder();
        boolean castTo = !timestamp && !unit.isDateUnit();
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("timestampadd(sql_tsi_frac_second");
                break;
            }
            default: {
                pattern.append("dateadd(?1");
            }
        }
        pattern.append(", ?2, ");
        if (castTo) {
            pattern.append("cast(?3 as timestamp)");
        } else {
            pattern.append("?3");
        }
        pattern.append(")");
        return pattern.toString();
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, boolean fromTimestamp, boolean toTimestamp) {
        StringBuilder pattern = new StringBuilder();
        boolean castFrom = !fromTimestamp && !unit.isDateUnit();
        boolean castTo = !toTimestamp && !unit.isDateUnit();
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("timestampdiff(sql_tsi_frac_second");
                break;
            }
            default: {
                pattern.append("datediff(?1");
            }
        }
        pattern.append(", ");
        if (castFrom) {
            pattern.append("cast(?2 as timestamp)");
        } else {
            pattern.append("?2");
        }
        pattern.append(", ");
        if (castTo) {
            pattern.append("cast(?3 as timestamp)");
        } else {
            pattern.append("?3");
        }
        pattern.append(")");
        return pattern.toString();
    }

    @Override
    public boolean supportsLockTimeouts() {
        return false;
    }

    @Override
    public String getForUpdateString() {
        if (this.version >= 200) {
            return " for update";
        }
        return "";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return this.version < 200 ? LegacyHSQLLimitHandler.INSTANCE : (this.version < 250 ? LimitOffsetLimitHandler.INSTANCE : OffsetFetchLimitHandler.INSTANCE);
    }

    @Override
    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public boolean supportsColumnCheck() {
        return this.version >= 200;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return HSQLSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from information_schema.sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorHSQLDBDatabaseImpl.INSTANCE;
    }

    @Override
    public String getFromDual() {
        return "from (values(0))";
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return this.version < 200 ? EXTRACTOR_18 : EXTRACTOR_20;
    }

    @Override
    public String getSelectClauseNullString(int sqlType) {
        String literal;
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                literal = "cast(null as varchar(100))";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                literal = "cast(null as varbinary(100))";
                break;
            }
            case 2005: {
                literal = "cast(null as clob)";
                break;
            }
            case 2004: {
                literal = "cast(null as blob)";
                break;
            }
            case 91: {
                literal = "cast(null as date)";
                break;
            }
            case 93: 
            case 2014: {
                literal = "cast(null as timestamp)";
                break;
            }
            case 16: {
                literal = "cast(null as boolean)";
                break;
            }
            case -7: {
                literal = "cast(null as bit)";
                break;
            }
            case 92: {
                literal = "cast(null as time)";
                break;
            }
            default: {
                literal = "cast(null as int)";
            }
        }
        return literal;
    }

    @Override
    public boolean supportsUnionAll() {
        return true;
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        if (this.version < 200) {
            return new GlobalTemporaryTableStrategy(new IdTable(rootEntityDescriptor, name -> "HT_" + name), () -> new TempIdTableExporter(false, this::getTypeName), AfterUseAction.CLEAN, runtimeModelCreationContext.getSessionFactory());
        }
        return new LocalTemporaryTableStrategy(new IdTable(rootEntityDescriptor, name -> "MODULE.HT_" + name), () -> new TempIdTableExporter(true, this::getTypeName){

            @Override
            protected String getCreateCommand() {
                return "declare local temporary table";
            }
        }, AfterUseAction.DROP, TempTableDdlTransactionHandling.NONE, runtimeModelCreationContext.getSessionFactory());
    }

    @Override
    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    @Override
    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "call current_timestamp";
    }

    @Override
    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_FORCE_INCREMENT: {
                return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_WRITE: {
                return new PessimisticWriteSelectLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_READ: {
                return new PessimisticReadSelectLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC: {
                return new OptimisticLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
        }
        if (this.version < 200) {
            return new ReadUncommittedLockingStrategy(lockable, lockMode);
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }

    @Override
    public boolean supportsCommentOn() {
        return this.version >= 200;
    }

    @Override
    public boolean supportsEmptyInList() {
        return false;
    }

    @Override
    public boolean requiresCastingOfParametersInSelectClause() {
        return true;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return this.version >= 200;
    }

    @Override
    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return this.version >= 200;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public String toBooleanValueString(boolean bool) {
        return String.valueOf(bool);
    }

    @Override
    public boolean supportsTupleDistinctCounts() {
        return this.version >= 229;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return new HSQLIdentityColumnSupport(this.version);
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    @Override
    public boolean supportsNamedParameters(DatabaseMetaData databaseMetaData) {
        return false;
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getCascadeConstraintsString() {
        return " cascade ";
    }

    @Override
    public String translateDatetimeFormat(String format) {
        return OracleDialect.datetimeFormat(format, false).replace("SSSSSS", "FF").replace("SSSSS", "FF").replace("SSSS", "FF").replace("SSS", "FF").replace("SS", "FF").replace("S", "FF").result();
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "week_of_year";
            }
        }
        return unit.toString();
    }

    private static class ReadUncommittedLockingStrategy
    extends SelectLockingStrategy {
        private ReadUncommittedLockingStrategy(Lockable lockable, LockMode lockMode) {
            super(lockable, lockMode);
        }

        @Override
        public void lock(Object id, Object version, Object object, int timeout, SharedSessionContractImplementor session) throws StaleObjectStateException, JDBCException {
            if (this.getLockMode().greaterThan(LockMode.READ)) {
                LOG.hsqldbSupportsOnlyReadCommittedIsolation();
            }
            super.lock(id, version, object, timeout, session);
        }
    }
}

