/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.InnoDBStorageEngine;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.MySQLStorageEngine;
import org.hibernate.dialect.sequence.ANSISequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorMariaDBDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;

public class MariaDBDialect
extends MySQLDialect {
    private final int version;

    int getMariaVersion() {
        return this.version;
    }

    public MariaDBDialect() {
        this(500);
    }

    public MariaDBDialect(int version) {
        super(version < 530 ? 500 : 570);
        this.version = version;
    }

    public MariaDBDialect(DialectResolutionInfo info) {
        this(info.getDatabaseMajorVersion() * 100 + info.getDatabaseMinorVersion() * 10);
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        if (this.getMariaVersion() >= 1020) {
            queryEngine.getSqmFunctionRegistry().registerNamed("json_valid", StandardBasicTypes.NUMERIC_BOOLEAN);
        }
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInInList() {
        return true;
    }

    @Override
    public boolean supportsColumnCheck() {
        return this.getMariaVersion() >= 1020;
    }

    @Override
    protected MySQLStorageEngine getDefaultMySQLStorageEngine() {
        return InnoDBStorageEngine.INSTANCE;
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return this.getMariaVersion() >= 1000;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getMariaVersion() < 1030 ? super.getSequenceSupport() : ANSISequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return this.getSequenceSupport().supportsSequences() ? "select table_name from information_schema.TABLES where table_schema = database() and table_type = 'SEQUENCE'" : super.getQuerySequencesString();
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return this.getSequenceSupport().supportsSequences() ? SequenceInformationExtractorMariaDBDatabaseImpl.INSTANCE : super.getSequenceInformationExtractor();
    }

    @Override
    public String getWriteLockString(int timeout) {
        if (this.getMariaVersion() < 1030) {
            return super.getWriteLockString(timeout);
        }
        if (timeout == 0) {
            return this.getForUpdateNowaitString();
        }
        if (timeout > 0) {
            return this.getForUpdateString() + " wait " + timeout;
        }
        return this.getForUpdateString();
    }

    @Override
    public String getForUpdateNowaitString() {
        return this.getMariaVersion() < 1030 ? super.getForUpdateNowaitString() : this.getForUpdateString() + " nowait";
    }

    @Override
    public String getForUpdateNowaitString(String aliases) {
        return this.getMariaVersion() < 1030 ? super.getForUpdateNowaitString(aliases) : this.getForUpdateString(aliases) + " nowait";
    }
}

