/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.DatabaseMetaData;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.sequence.MaxDBSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.query.TrimSpec;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DecodeCaseFragment;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorSAPDBDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.StandardBasicTypes;

public class MaxDBDialect
extends Dialect {
    public MaxDBDialect() {
        this.registerColumnType(-7, 1L, "boolean");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(-5, "fixed(19,0)");
        this.registerColumnType(2, "fixed($p,$s)");
        this.registerColumnType(3, "fixed($p,$s)");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(2014, "timestamp");
        this.registerColumnType(-3, "long byte");
        this.registerColumnType(2005, "long varchar");
        this.registerColumnType(2004, "long byte");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public void initializeFunctionRegistry(QueryEngine queryEngine) {
        super.initializeFunctionRegistry(queryEngine);
        CommonFunctionFactory.log(queryEngine);
        CommonFunctionFactory.pi(queryEngine);
        CommonFunctionFactory.cot(queryEngine);
        CommonFunctionFactory.cosh(queryEngine);
        CommonFunctionFactory.sinh(queryEngine);
        CommonFunctionFactory.tanh(queryEngine);
        CommonFunctionFactory.radians(queryEngine);
        CommonFunctionFactory.degrees(queryEngine);
        CommonFunctionFactory.trunc(queryEngine);
        CommonFunctionFactory.trim2(queryEngine);
        CommonFunctionFactory.substr(queryEngine);
        CommonFunctionFactory.substring_substr(queryEngine);
        CommonFunctionFactory.translate(queryEngine);
        CommonFunctionFactory.initcap(queryEngine);
        CommonFunctionFactory.soundex(queryEngine);
        CommonFunctionFactory.yearMonthDay(queryEngine);
        CommonFunctionFactory.hourMinuteSecond(queryEngine);
        CommonFunctionFactory.dayofweekmonthyear(queryEngine);
        CommonFunctionFactory.daynameMonthname(queryEngine);
        CommonFunctionFactory.dateTimeTimestamp(queryEngine);
        CommonFunctionFactory.ceiling_ceil(queryEngine);
        CommonFunctionFactory.week_weekofyear(queryEngine);
        CommonFunctionFactory.concat_pipeOperator(queryEngine);
        CommonFunctionFactory.coalesce_value(queryEngine);
        CommonFunctionFactory.pad_fill(queryEngine);
        CommonFunctionFactory.datediff(queryEngine);
        CommonFunctionFactory.adddateSubdateAddtimeSubtime(queryEngine);
        CommonFunctionFactory.addMonths(queryEngine);
        queryEngine.getSqmFunctionRegistry().registerPattern("extract", "?1(?2)", StandardBasicTypes.INTEGER);
        queryEngine.getSqmFunctionRegistry().patternDescriptorBuilder("nullif", "case ?1 when ?2 then null else ?1 end").setExactArgumentCount(2).register();
        queryEngine.getSqmFunctionRegistry().namedDescriptorBuilder("index").setInvariantType(StandardBasicTypes.INTEGER).setArgumentCountBetween(2, 4).register();
        queryEngine.getSqmFunctionRegistry().registerBinaryTernaryPattern("locate", StandardBasicTypes.INTEGER, "index(?2, ?1)", "index(?2, ?1, ?3)").setArgumentListSignature("(pattern, string[, start])");
    }

    @Override
    public String trimPattern(TrimSpec specification, char character) {
        return AbstractTransactSQLDialect.replaceLtrimRtrim(specification, character);
    }

    @Override
    public boolean dropConstraints() {
        return false;
    }

    @Override
    public String getAddColumnString() {
        return "add";
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        StringBuilder res = new StringBuilder(30).append(" foreign key ").append(constraintName).append(" (").append(String.join((CharSequence)", ", foreignKey)).append(") references ").append(referencedTable);
        if (!referencesPrimaryKey) {
            res.append(" (").append(String.join((CharSequence)", ", primaryKey)).append(')');
        }
        return res.toString();
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String foreignKeyDefinition) {
        return foreignKeyDefinition;
    }

    @Override
    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " primary key ";
    }

    @Override
    public String getNullColumnString() {
        return " null";
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return MaxDBSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from domain.sequences";
    }

    @Override
    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorSAPDBDatabaseImpl.INSTANCE;
    }

    @Override
    public String getFromDual() {
        return "from dual";
    }

    @Override
    public CaseFragment createCaseFragment() {
        return new DecodeCaseFragment();
    }

    @Override
    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public boolean supportsJdbcConnectionLobCreation(DatabaseMetaData databaseMetaData) {
        return false;
    }
}

